#!/usr/bin/env python
# encoding: utf-8

name = "H_Abstraction/TS_training"
shortDesc = u"Distances used to train group additivity values for TS geometries"
longDesc = u"""
Put interatomic distances for reactions to use as a training set for fitting
group additivity values in this file.
"""
recommended = True

entry(
    index = 1,
    reactant1 = """
1 *2 H u0 p0 c0  {2,S}
2 *1 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.40773504244', 'd12': '0.895297060023', 'd13': '2.30303210246'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 2,
    reactant1 = """
1 *2 H u0 p0 c0  {2,S}
2 *1 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product2 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *1 C u0 p0 c0  {1,S} {3,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.35892133446', 'd12': '0.930299051641', 'd13': '2.28893519078'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 3,
    reactant1 = """
1 *2 H u0 p0 c0  {2,S}
2 *1 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 O u1 p2 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.20216645606', 'd12': '0.907894558278', 'd13': '2.10402794429'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 4,
    reactant1 = """
1 *2 H u0 p0 c0  {2,S}
2 *1 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product2 = """
1 *1 C u0 p0 c0  {2,S} {3,D} {4,S}
2 *2 H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
4    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.21988501633', 'd12': '1.15309849454', 'd13': '2.37290946709'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 5,
    reactant1 = """
1 *2 H u0 p0 c0  {2,S}
2 *1 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product2 = """
1    C u0 p0 c0  {2,D} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,D} {3,S} {6,S}
3 *2 H u0 p0 c0  {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.46347894682', 'd12': '0.862862296846', 'd13': '2.32579722591'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 6,
    reactant1 = """
1 *2 H u0 p0 c0  {2,S}
2 *1 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2 *3 O u1 p2 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product2 = """
1    O u0 p2 c0  {2,S} {4,S}
2 *1 O u0 p2 c0  {1,S} {3,S}
3 *2 H u0 p0 c0  {2,S}
4    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.06757172779', 'd12': '1.11574127633', 'd13': '2.1796554827'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 7,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.926273983824', 'd12': '1.36413844572', 'd13': '2.29011119802'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 8,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.08060600298', 'd12': '1.23289966705', 'd13': '2.31166939106'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 9,
    reactant1 = """
1 *2 H u0 p0 c0  {2,S}
2 *1 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *3 O u1 p2 c0  {2,S}
""",
    product1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product2 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    O u0 p2 c0  {1,S} {3,S}
3 *1 O u0 p2 c0  {2,S} {7,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7 *2 H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.04828664688', 'd12': '1.17928080736', 'd13': '2.22345150147'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 10,
    reactant1 = """
1 *2 H u0 p0 c0  {2,S}
2 *1 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    product1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': '1.19436701782', 'd12': '1.23398956601', 'd13': '2.42765010692'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 11,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3 *1 C u0 p0 c0  {2,D} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3 *3 C u1 p0 c0  {2,D} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.856116451331', 'd12': '1.47813602871', 'd13': '2.33353250223'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 12,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *1 C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7 *2 H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {3,D} {7,S} {8,S}
3 *3 C u1 p0 c0  {1,S} {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.890380160538', 'd12': '1.41348718108', 'd13': '2.3037243324'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 13,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3  *1 C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {2,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.929233924724', 'd12': '1.36327979666', 'd13': '2.29221727048'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 14,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,D} {5,S}
2     C u0 p0 c0  {1,S} {4,D} {6,S}
3  *1 C u0 p0 c0  {1,D} {7,S} {8,S}
4     C u0 p0 c0  {2,D} {9,S} {10,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {3,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {4,S}
10    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {5,S}
2    C u0 p0 c0  {1,S} {4,D} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4 *3 C u1 p0 c0  {2,D} {9,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.857297575577', 'd12': '1.47462637073', 'd13': '2.33091998893'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 15,
    reactant1 = """
1 *2 H u0 p0 c0  {2,S}
2 *1 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {4,S} {10,S} {11,S} {12,S}
4  *3 C u1 p0 c0  {1,S} {3,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
""",
    product1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product2 = """
1     C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {5,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {2,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.30720965209', 'd12': '0.974384887201', 'd13': '2.28142288545'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 16,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3  *1 C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     O u0 p2 c0  {2,S} {12,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     O u0 p2 c0  {2,S} {11,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.929232557334', 'd12': '1.36776843715', 'd13': '2.2968743381'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 17,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1 *1 C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {3,S} {7,D} {8,S}
3    O u0 p2 c0  {1,S} {2,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {3,S} {5,S} {6,S}
2    C u0 p0 c0  {3,S} {4,D} {7,S}
3    O u0 p2 c0  {1,S} {2,S}
4    O u0 p2 c0  {2,D}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.955049619099', 'd12': '1.32911528045', 'd13': '2.28383585417'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 18,
    reactant1 = """
1 *2 H u0 p0 c0  {2,S}
2 *1 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {4,D} {11,S}
4  *3 C u1 p0 c0  {2,S} {3,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product2 = """
1     C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {4,D} {12,S}
4  *1 C u0 p0 c0  {2,S} {3,D} {11,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11 *2 H u0 p0 c0  {4,S}
12    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.41659613444', 'd12': '0.887625561499', 'd13': '2.30400248858'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 19,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4  *1 C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5     O u0 p2 c0  {3,S} {15,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12 *2 H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {2,S} {12,S} {13,S}
5     O u0 p2 c0  {3,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.929562714059', 'd12': '1.35777238782', 'd13': '2.28701840306'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 20,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     O u0 p2 c0  {1,S} {15,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     O u0 p2 c0  {1,S} {14,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.923478017904', 'd12': '1.36923344491', 'd13': '2.29270714272'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 21,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {5,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5  *1 C u0 p0 c0  {2,S} {9,S} {16,S} {17,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {5,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {5,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 C u1 p0 c0  {2,S} {15,S} {16,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.927276316146', 'd12': '1.36286435818', 'd13': '2.28958345535'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 22,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2  *1 C u0 p0 c0  {1,S} {5,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     C u0 p0 c0  {2,S} {15,S} {16,S} {17,S}
6     H u0 p0 c0  {1,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {5,S} {13,S} {14,S} {15,S}
5  *3 C u1 p0 c0  {1,S} {4,S} {16,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.970596361047', 'd12': '1.31339574095', 'd13': '2.28396108373'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 23,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {6,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5     C u0 p0 c0  {3,S} {15,S} {16,S} {17,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {5,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {5,S} {13,S} {14,S} {15,S}
5  *3 C u1 p0 c0  {2,S} {4,S} {16,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.976300411313', 'd12': '1.30507883057', 'd13': '2.28125066263'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 24,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     C u0 p0 c0  {1,S} {15,S} {16,S} {17,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 C u1 p0 c0  {1,S} {15,S} {16,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.919883004244', 'd12': '1.37805888248', 'd13': '2.29790558097'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 25,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {5,S} {7,S} {8,S}
3  *1 C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     C u0 p0 c0  {2,S} {15,S} {16,S} {17,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5  *3 C u1 p0 c0  {1,S} {15,S} {16,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.92744513748', 'd12': '1.37106798486', 'd13': '2.29850984591'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 26,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.850034093713', 'd12': '1.4930819397', 'd13': '2.34311603157'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 27,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {5,B} {8,S}
3     C u0 p0 c0  {1,B} {6,B} {9,S}
4     C u0 p0 c0  {5,B} {6,B} {10,S}
5     C u0 p0 c0  {2,B} {4,B} {11,S}
6     C u0 p0 c0  {3,B} {4,B} {12,S}
7  *1 O u0 p2 c0  {1,S} {13,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13 *2 H u0 p0 c0  {7,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {5,B} {8,S}
3     C u0 p0 c0  {1,B} {6,B} {9,S}
4     C u0 p0 c0  {5,B} {6,B} {10,S}
5     C u0 p0 c0  {2,B} {4,B} {11,S}
6     C u0 p0 c0  {3,B} {4,B} {12,S}
7  *3 O u1 p2 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.08657681722', 'd12': '1.08110686108', 'd13': '2.16027024006'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 28,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {9,S} {10,S}
2  *1 C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
3     C u0 p0 c0  {1,S} {4,B} {5,B}
4     C u0 p0 c0  {3,B} {7,B} {14,S}
5     C u0 p0 c0  {3,B} {8,B} {15,S}
6     C u0 p0 c0  {7,B} {8,B} {16,S}
7     C u0 p0 c0  {4,B} {6,B} {17,S}
8     C u0 p0 c0  {5,B} {6,B} {18,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {2,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {6,S}
17    H u0 p0 c0  {7,S}
18    H u0 p0 c0  {8,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {8,S} {9,S} {10,S}
2     C u0 p0 c0  {1,S} {3,B} {4,B}
3     C u0 p0 c0  {2,B} {6,B} {11,S}
4     C u0 p0 c0  {2,B} {7,B} {12,S}
5     C u0 p0 c0  {6,B} {7,B} {13,S}
6     C u0 p0 c0  {3,B} {5,B} {14,S}
7     C u0 p0 c0  {4,B} {5,B} {15,S}
8  *3 C u1 p0 c0  {1,S} {16,S} {17,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {5,S}
14    H u0 p0 c0  {6,S}
15    H u0 p0 c0  {7,S}
16    H u0 p0 c0  {8,S}
17    H u0 p0 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': '0.923728822558', 'd12': '1.36787122418', 'd13': '2.29107401551'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via double-ended TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 29,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.37890', 'd12': '1.33014', 'd13': '2.70895'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 30,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.44233', 'd12': '1.28923', 'd13': '2.73121'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 31,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *1 O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,S} {8,S}
3 *3 O u1 p2 c0  {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.30536', 'd12': '1.20569', 'd13': '2.51006'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 32,
    reactant1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2 *3 O u1 p2 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1    O u0 p2 c0  {2,S} {4,S}
2 *1 O u0 p2 c0  {1,S} {3,S}
3 *2 H u0 p0 c0  {2,S}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.14362', 'd12': '1.40355', 'd13': '2.54716'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 33,
    reactant1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2 *3 O u1 p2 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1    O u0 p2 c0  {2,S} {4,S}
2 *1 O u0 p2 c0  {1,S} {3,S}
3 *2 H u0 p0 c0  {2,S}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.22242', 'd12': '1.32319', 'd13': '2.54544'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 34,
    reactant1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2 *3 O u1 p2 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *1 O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1    O u0 p2 c0  {2,S} {4,S}
2 *1 O u0 p2 c0  {1,S} {3,S}
3 *2 H u0 p0 c0  {2,S}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,S} {8,S}
3 *3 O u1 p2 c0  {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.10392', 'd12': '1.27899', 'd13': '2.34834'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 35,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *1 C u0 p0 c0  {1,S} {3,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.37951', 'd12': '1.32326', 'd13': '2.70269'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 36,
    reactant1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2 *3 O u1 p2 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *1 C u0 p0 c0  {1,S} {3,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1    O u0 p2 c0  {2,S} {4,S}
2 *3 O u0 p2 c0  {1,S} {3,S}
3 *2 H u0 p0 c0  {2,S}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.15831', 'd12': '1.38612', 'd13': '2.54409'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 37,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,D} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,D} {3,S} {6,S}
3 *2 H u0 p0 c0  {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.31192', 'd12': '1.37209', 'd13': '2.68374'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 38,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {4,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {8,S} {9,S}
3     C u0 p0 c0  {2,S} {4,S} {10,S} {11,S}
4  *1 C u0 p0 c0  {1,S} {3,S} {5,S} {12,S}
5  *2 H u0 p0 c0  {4,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
4  *3 C u1 p0 c0  {2,S} {3,S} {11,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.39021', 'd12': '1.31082', 'd13': '2.70089'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 39,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {3,S}
3    O u0 p2 c0  {1,S} {2,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {3,S}
3    O u0 p2 c0  {1,S} {2,S}
4    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.35719', 'd12': '1.33957', 'd13': '2.69461'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 40,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {3,S}
3    O u0 p2 c0  {1,S} {2,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {3,S}
3    O u0 p2 c0  {1,S} {2,S}
4    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.32993', 'd12': '1.37733', 'd13': '2.70362'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 41,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {2,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {6,S}
3    O u0 p2 c0  {1,S} {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.33663', 'd12': '1.36697', 'd13': '2.70329'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 42,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,S} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {2,S} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,S} {6,S} {7,S}
3 *3 C u1 p0 c0  {1,S} {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.30692', 'd12': '1.38471', 'd13': '2.69157'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 43,
    reactant1 = """
multiplicity 2
1 *3 O u1 p2 c0  {2,S}
2    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.39456', 'd12': '1.18856', 'd13': '2.58134'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 44,
    reactant1 = """
multiplicity 2
1 *3 O u1 p2 c0  {2,S}
2    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *1 O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,S} {8,S}
3 *3 O u1 p2 c0  {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': '1.32977', 'd12': '1.05831', 'd13': '2.28959'},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation""",
    longDesc = 
u"""
""",
)

entry(
    index = 45,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 O u1 p2 c0  {2,S}
2    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 0.808251, 'd12': 1.407349, 'd13': 2.196944},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 46,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    distances = DistanceData(
        distances = {'d23': 1.296176, 'd12': 1.002833, 'd13': 2.29898},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 47,
    reactant1 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1    H u0 p0 c0  {2,S}
2 *3 O u1 p2 c0  {1,S}
""",
    product2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.216325, 'd12': 1.324475, 'd13': 2.537847},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 48,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *1 O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *3 O u1 p2 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 0.91111, 'd12': 1.201, 'd13': 2.10677},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 49,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.060399, 'd12': 1.250952, 'd13': 2.311305},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 50,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 0.926377, 'd12': 1.366101, 'd13': 2.29247},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 51,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *3 O u1 p2 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.19983, 'd12': 1.310536, 'd13': 2.509181},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 52,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,D}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,D} {4,S}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.274424, 'd12': 1.486471, 'd13': 2.760463},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 53,
    reactant1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product1 = """
1    O u0 p2 c0  {2,S} {3,S}
2 *1 O u0 p2 c0  {1,S} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.126056, 'd12': 1.425793, 'd13': 2.55168},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 54,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,S} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {2,S} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,S} {6,S} {7,S}
3 *3 C u1 p0 c0  {1,S} {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 0.877258, 'd12': 1.430155, 'd13': 2.306828},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 55,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {2,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {6,S}
3    O u0 p2 c0  {1,S} {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 0.927201, 'd12': 1.366575, 'd13': 2.293246},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 56,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1 *1 C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3    O u0 p2 c0  {1,S} {2,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {3,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.008692, 'd12': 1.297897, 'd13': 2.306541},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 57,
    reactant1 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
multiplicity 2
1    H u0 p0 c0  {2,S}
2 *3 O u1 p2 c0  {1,S}
""",
    product2 = """
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *1 C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6 *2 H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.235607, 'd12': 1.272333, 'd13': 2.495812},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 58,
    reactant1 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2 *3 O u1 p2 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1    H u0 p0 c0  {2,S}
2 *3 O u1 p2 c0  {1,S}
""",
    product2 = """
1    O u0 p2 c0  {2,S} {3,S}
2 *1 O u0 p2 c0  {1,S} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.002539, 'd12': 1.591884, 'd13': 2.498974},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 59,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1 *3 O u1 p2 c0  {2,S}
2    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.162672, 'd12': 1.477049, 'd13': 2.638169},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 60,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.464952, 'd12': 1.262583, 'd13': 2.727535},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 61,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     O u0 p2 c0  {1,S} {12,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {4,S}
4     O u0 p2 c0  {3,S} {11,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.176607, 'd12': 1.193929, 'd13': 2.370363},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 62,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,D}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,D}
3 *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.012158, 'd12': 1.268907, 'd13': 2.279237},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 63,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *3 O u1 p2 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.246208, 'd12': 1.275568, 'd13': 2.521678},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 64,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.380732, 'd12': 1.32602, 'd13': 2.706495},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 65,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {2,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {6,S}
3    O u0 p2 c0  {1,S} {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.363688, 'd12': 1.332471, 'd13': 2.695568},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 66,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.470831, 'd12': 1.26608, 'd13': 2.736083},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 67,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3    O u0 p2 c0  {1,S} {2,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {3,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.430905, 'd12': 1.302739, 'd13': 2.733224},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 68,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    distances = DistanceData(
        distances = {'d23': 1.371495, 'd12': 0.926853, 'd13': 2.298343},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 69,
    reactant1 = """
1    O u0 p2 c0  {2,S} {3,S}
2 *1 O u0 p2 c0  {1,S} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    product2 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.317309, 'd12': 1.223801, 'd13': 2.535817},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 70,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,D}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,D}
3 *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.429246, 'd12': 1.284618, 'd13': 2.712247},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 71,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.33542, 'd12': 1.380621, 'd13': 2.716025},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 72,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *3 O u1 p2 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    O u0 p2 c0  {1,S} {3,S}
3 *1 O u0 p2 c0  {2,S} {7,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7 *2 H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.149865, 'd12': 1.40219, 'd13': 2.551133},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 73,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.355809, 'd12': 1.356755, 'd13': 2.71208},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 74,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *3 O u1 p2 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.289857, 'd12': 1.24964, 'd13': 2.539487},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 75,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *3 O u1 p2 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.248587, 'd12': 1.276309, 'd13': 2.524895},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 76,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,D}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,D} {4,S}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.329108, 'd12': 1.421184, 'd13': 2.749792},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 77,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,D}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,D}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    O u0 p2 c0  {1,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.306486, 'd12': 1.449892, 'd13': 2.754254},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 78,
    reactant1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1    O u0 p2 c0  {2,S} {3,S}
2 *1 O u0 p2 c0  {1,S} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.185967, 'd12': 1.355088, 'd13': 2.540637},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 79,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.377889, 'd12': 1.328058, 'd13': 2.705697},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 80,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {5,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     C u0 p0 c0  {2,S} {15,S} {16,S} {17,S}
6  *2 H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {5,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {5,S} {14,S} {15,S} {16,S}
5  *3 C u1 p0 c0  {1,S} {3,S} {4,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.065669, 'd12': 1.235549, 'd13': 2.301216},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 81,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {4,S} {10,S} {11,S} {12,S}
4  *3 C u1 p0 c0  {1,S} {3,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.409141, 'd12': 1.307025, 'd13': 2.715605},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 82,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3  *1 C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {2,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.381915, 'd12': 1.325846, 'd13': 2.707452},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 83,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,D} {5,S}
2     C u0 p0 c0  {1,S} {4,D} {6,S}
3  *1 C u0 p0 c0  {1,D} {7,S} {8,S}
4     C u0 p0 c0  {2,D} {9,S} {10,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {3,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {4,S}
10    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {5,S}
2    C u0 p0 c0  {1,S} {4,D} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4 *3 C u1 p0 c0  {2,D} {9,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.299711, 'd12': 1.382945, 'd13': 2.682409},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 84,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4  *1 C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5     C u0 p0 c0  {3,S} {15,S} {16,S} {17,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12 *2 H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5  *3 C u1 p0 c0  {3,S} {15,S} {16,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 0.930376, 'd12': 1.362744, 'd13': 2.292827},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 85,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5     C u0 p0 c0  {3,S} {15,S} {16,S} {17,S}
6  *2 H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {5,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5  *3 C u1 p0 c0  {1,S} {2,S} {16,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 0.968067, 'd12': 1.319334, 'd13': 2.286248},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 86,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4443, 'd12': 1.287947, 'd13': 2.732236},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 87,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.513197, 'd12': 1.235324, 'd13': 2.74749},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 88,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,S} {12,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,S} {11,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.463225, 'd12': 1.272173, 'd13': 2.734469},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 89,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {5,S} {12,S} {13,S}
5     C u0 p0 c0  {3,S} {4,S} {14,S} {15,S}
6  *2 H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {5,S}
15    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {5,S} {12,S} {13,S}
5  *3 C u1 p0 c0  {3,S} {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 0.994169, 'd12': 1.282451, 'd13': 2.276393},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 90,
    reactant1 = """
multiplicity 2
1 *1 O u0 p2 c0  {2,S} {3,S}
2 *2 H u0 p0 c0  {1,S}
3    O u1 p2 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 3
1 *3 O u1 p2 c0  {2,S}
2    O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48516, 'd12': 1.131035, 'd13': 2.614105},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 91,
    reactant1 = """
1    O u0 p2 c0  {2,S} {3,S}
2 *1 O u0 p2 c0  {1,S} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    product2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *1 C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11 *2 H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.38475, 'd12': 1.160095, 'd13': 2.544667},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 92,
    reactant1 = """
1    O u0 p2 c0  {2,S} {3,S}
2 *1 O u0 p2 c0  {1,S} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    product1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    product2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.32645, 'd12': 1.222161, 'd13': 2.548529},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 93,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {4,D} {10,S}
4     C u0 p0 c0  {3,D} {11,S} {12,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2  *3 C u1 p0 c0  {1,S} {3,S} {8,S}
3     C u0 p0 c0  {2,S} {4,D} {9,S}
4     C u0 p0 c0  {3,D} {10,S} {11,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.493337, 'd12': 1.255489, 'd13': 2.74766},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 94,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {3,S} {7,D} {8,S}
3    O u0 p2 c0  {1,S} {2,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {3,S} {5,S} {6,S}
2    C u0 p0 c0  {3,S} {4,D} {7,S}
3    O u0 p2 c0  {1,S} {2,S}
4    O u0 p2 c0  {2,D}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.380239, 'd12': 1.321635, 'd13': 2.701664},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 95,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {5,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     O u0 p2 c0  {1,S} {2,S}
6  *2 H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {3,S} {5,S} {14,S}
5     O u0 p2 c0  {1,S} {4,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.455335, 'd12': 1.287741, 'd13': 2.74237},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 96,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,D}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,D}
3 *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.464653, 'd12': 1.254446, 'd13': 2.717863},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 97,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {2,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3  *1 C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11 *2 H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.353827, 'd12': 1.354599, 'd13': 2.708409},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 98,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.331478, 'd12': 1.4283, 'd13': 2.756683},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 99,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.309076, 'd12': 1.457569, 'd13': 2.765122},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 100,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.352875, 'd12': 1.359062, 'd13': 2.711432},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 101,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {1,S} {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.330919, 'd12': 1.229832, 'd13': 2.560671},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 102,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *3 O u1 p2 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.246807, 'd12': 1.280576, 'd13': 2.526767},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 103,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,D}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,D} {4,S}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.30392, 'd12': 1.45327, 'd13': 2.755748},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 104,
    reactant1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1    O u0 p2 c0  {2,S} {3,S}
2 *1 O u0 p2 c0  {1,S} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {1,S} {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.210177, 'd12': 1.332136, 'd13': 2.542273},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 105,
    reactant1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1    O u0 p2 c0  {2,S} {3,S}
2 *1 O u0 p2 c0  {1,S} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {4,S} {10,S} {11,S} {12,S}
4  *3 C u1 p0 c0  {1,S} {3,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.188088, 'd12': 1.355607, 'd13': 2.543226},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 106,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {3,D} {7,S}
3     C u0 p0 c0  {2,D} {8,S} {9,S}
4     O u0 p2 c0  {1,S} {10,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {5,S}
2 *3 C u1 p0 c0  {1,S} {4,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    O u0 p2 c0  {2,S} {9,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.483497, 'd12': 1.271122, 'd13': 2.75044},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 107,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {5,S} {12,S} {13,S}
5     C u0 p0 c0  {3,S} {4,S} {14,S} {15,S}
6  *2 H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {5,S}
15    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {5,S} {12,S} {13,S}
5  *3 C u1 p0 c0  {3,S} {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.418941, 'd12': 1.291399, 'd13': 2.710328},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 108,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     C u0 p0 c0  {1,S} {15,S} {16,S} {17,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 C u1 p0 c0  {1,S} {15,S} {16,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.376535, 'd12': 1.333048, 'd13': 2.708112},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 109,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2  *1 C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {4,S} {11,D}
4     O u0 p2 c0  {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8  *2 H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {3,D}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,D}
3  *3 C u1 p0 c0  {4,S} {9,S} {10,S}
4     O u0 p2 c0  {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     O u0 p2 c0  {2,D}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.38536, 'd12': 1.318788, 'd13': 2.703903},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 110,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {4,S} {11,D}
4     O u0 p2 c0  {2,S} {3,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {3,D}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {4,S} {8,D}
3  *3 C u1 p0 c0  {2,S} {9,S} {10,S}
4     O u0 p2 c0  {1,S} {2,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     O u0 p2 c0  {2,D}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.403984, 'd12': 1.298579, 'd13': 2.702172},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 111,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,D} {10,S}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     O u0 p2 c0  {3,D}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    C u0 p0 c0  {2,S} {8,D} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
9    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.453078, 'd12': 1.280278, 'd13': 2.731984},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 112,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,D} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     O u0 p2 c0  {3,D}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
3    C u0 p0 c0  {1,S} {6,D} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {3,D}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.343187, 'd12': 1.364407, 'd13': 2.707408},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 113,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {5,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     O u0 p2 c0  {1,S} {2,S}
6  *2 H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {3,S} {5,S} {14,S}
5     O u0 p2 c0  {1,S} {4,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.421882, 'd12': 1.318758, 'd13': 2.74022},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 114,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {1,S} {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.384498, 'd12': 1.346259, 'd13': 2.730612},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 115,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *3 O u1 p2 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    O u0 p2 c0  {1,S} {3,S}
3 *1 O u0 p2 c0  {2,S} {7,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7 *2 H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {1,S} {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.201517, 'd12': 1.34754, 'd13': 2.547347},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 116,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *3 O u1 p2 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    O u0 p2 c0  {1,S} {3,S}
3 *1 O u0 p2 c0  {2,S} {7,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7 *2 H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.152543, 'd12': 1.404984, 'd13': 2.557307},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 117,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.356039, 'd12': 1.360934, 'd13': 2.716761},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 118,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {1,S} {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.351842, 'd12': 1.408127, 'd13': 2.756651},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 119,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.307129, 'd12': 1.461382, 'd13': 2.768218},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 120,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     O u0 p2 c0  {1,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {16,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16 *2 H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     O u0 p2 c0  {1,S} {15,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15 *3 O u1 p2 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.453162, 'd12': 1.113429, 'd13': 2.565773},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 121,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8  *2 H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.44811, 'd12': 1.286944, 'd13': 2.734005},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 122,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {5,S} {12,S} {13,S}
5     C u0 p0 c0  {3,S} {4,S} {14,S} {15,S}
6  *2 H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {5,S}
15    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {5,S} {12,S} {13,S}
5  *3 C u1 p0 c0  {3,S} {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.389466, 'd12': 1.322772, 'd13': 2.712125},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 123,
    reactant1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {5,S} {12,S} {13,S}
5     C u0 p0 c0  {3,S} {4,S} {14,S} {15,S}
6  *2 H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {5,S}
15    H u0 p0 c0  {5,S}
""",
    product1 = """
1    O u0 p2 c0  {2,S} {3,S}
2 *1 O u0 p2 c0  {1,S} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {5,S} {12,S} {13,S}
5  *3 C u1 p0 c0  {3,S} {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.195943, 'd12': 1.347002, 'd13': 2.542942},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 124,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {4,S} {6,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {4,S} {5,S} {12,D}
4     O u0 p2 c0  {1,S} {3,S}
5     O u0 p2 c0  {2,S} {3,S}
6  *2 H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    O u0 p2 c0  {3,D}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {6,S} {7,S} {8,S}
2     C u0 p0 c0  {4,S} {5,S} {9,D}
3  *3 C u1 p0 c0  {5,S} {10,S} {11,S}
4     O u0 p2 c0  {1,S} {2,S}
5     O u0 p2 c0  {2,S} {3,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     O u0 p2 c0  {2,D}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.382092, 'd12': 1.321991, 'd13': 2.703748},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 125,
    reactant1 = """
multiplicity 2
1    H u0 p0 c0  {2,S}
2 *3 O u1 p2 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {9,S}
2     C u0 p0 c0  {1,B} {4,B} {7,S}
3     C u0 p0 c0  {1,B} {5,B} {8,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.259028, 'd12': 1.243519, 'd13': 2.490608},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 126,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 O u1 p2 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 O u0 p2 c0  {1,S} {15,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15 *2 H u0 p0 c0  {5,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.405721, 'd12': 1.205245, 'd13': 2.603715},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 127,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 O u1 p2 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 O u0 p2 c0  {1,S} {15,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15 *2 H u0 p0 c0  {5,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.25767, 'd12': 1.278589, 'd13': 2.534594},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 128,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8  *2 H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {1,S} {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.410864, 'd12': 1.321875, 'd13': 2.730185},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 129,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {6,S} {13,S} {14,S}
5     C u0 p0 c0  {3,S} {6,D} {15,S}
6     C u0 p0 c0  {4,S} {5,D} {16,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {5,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {6,S} {11,S} {12,S}
4  *3 C u1 p0 c0  {1,S} {3,S} {13,S}
5     C u0 p0 c0  {2,S} {6,D} {15,S}
6     C u0 p0 c0  {3,S} {5,D} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {6,S}
15    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.370231, 'd12': 1.341899, 'd13': 2.712072},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 130,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     C u0 p0 c0  {1,S} {15,S} {16,S} {17,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 C u1 p0 c0  {1,S} {15,S} {16,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.33492, 'd12': 1.390728, 'd13': 2.723733},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 131,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,D} {8,S}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4     C u0 p0 c0  {2,D} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6  *2 H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1  *3 C u1 p0 c0  {2,S} {3,S} {6,S}
2     C u0 p0 c0  {1,S} {4,D} {7,S}
3     C u0 p0 c0  {1,S} {5,D} {8,S}
4     C u0 p0 c0  {2,D} {5,S} {9,S}
5     C u0 p0 c0  {3,D} {4,S} {10,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {4,S}
10    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.391177, 'd12': 1.337615, 'd13': 2.727653},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 132,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,D} {8,S}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4     C u0 p0 c0  {2,D} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6  *2 H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1  *3 C u1 p0 c0  {2,S} {3,S} {6,S}
2     C u0 p0 c0  {1,S} {4,D} {7,S}
3     C u0 p0 c0  {1,S} {5,D} {8,S}
4     C u0 p0 c0  {2,D} {5,S} {9,S}
5     C u0 p0 c0  {3,D} {4,S} {10,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {4,S}
10    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.415978, 'd12': 1.314561, 'd13': 2.730215},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 133,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,D} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    O u0 p2 c0  {4,D}
13    H u0 p0 c0  {4,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {4,S} {10,S}
4     C u0 p0 c0  {3,S} {11,D} {12,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    O u0 p2 c0  {4,D}
12    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.454247, 'd12': 1.286158, 'd13': 2.739153},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 134,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {5,D} {12,S}
4     C u0 p0 c0  {1,S} {6,D} {13,S}
5     C u0 p0 c0  {3,D} {7,S} {15,S}
6     C u0 p0 c0  {4,D} {7,S} {16,S}
7     C u0 p0 c0  {5,S} {6,S} {14,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    O u0 p2 c0  {7,D}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {8,S} {9,S} {10,S}
2  *3 C u1 p0 c0  {1,S} {3,S} {4,S}
3     C u0 p0 c0  {2,S} {5,D} {12,S}
4     C u0 p0 c0  {2,S} {6,D} {13,S}
5     C u0 p0 c0  {3,D} {7,S} {14,S}
6     C u0 p0 c0  {4,D} {7,S} {15,S}
7     C u0 p0 c0  {5,S} {6,S} {11,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {1,S}
11    O u0 p2 c0  {7,D}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {5,S}
15    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.627066, 'd12': 1.210734, 'd13': 2.837081},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 135,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 O u1 p2 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,D}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 O u0 p2 c0  {1,S} {15,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15 *2 H u0 p0 c0  {5,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,D}
3 *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.254681, 'd12': 1.279753, 'd13': 2.532874},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 136,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 O u1 p2 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 O u0 p2 c0  {1,S} {15,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15 *2 H u0 p0 c0  {5,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {1,S} {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.318814, 'd12': 1.251585, 'd13': 2.554427},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 137,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 O u1 p2 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 O u0 p2 c0  {1,S} {15,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15 *2 H u0 p0 c0  {5,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.245048, 'd12': 1.288264, 'd13': 2.531537},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 138,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {8,S} {9,S} {10,S} {11,S}
2     C u0 p0 c0  {3,B} {4,B} {8,S}
3     C u0 p0 c0  {2,B} {6,B} {12,S}
4     C u0 p0 c0  {2,B} {7,B} {13,S}
5     C u0 p0 c0  {6,B} {7,B} {14,S}
6     C u0 p0 c0  {3,B} {5,B} {15,S}
7     C u0 p0 c0  {4,B} {5,B} {16,S}
8     O u0 p2 c0  {1,S} {2,S}
9  *2 H u0 p0 c0  {1,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {5,S}
15    H u0 p0 c0  {6,S}
16    H u0 p0 c0  {7,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {8,S}
2     C u0 p0 c0  {1,B} {5,B} {9,S}
3     C u0 p0 c0  {1,B} {6,B} {10,S}
4     C u0 p0 c0  {5,B} {6,B} {11,S}
5     C u0 p0 c0  {2,B} {4,B} {12,S}
6     C u0 p0 c0  {3,B} {4,B} {13,S}
7  *3 C u1 p0 c0  {8,S} {14,S} {15,S}
8     O u0 p2 c0  {1,S} {7,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {7,S}
15    H u0 p0 c0  {7,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4136, 'd12': 1.311451, 'd13': 2.724572},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 139,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 O u1 p2 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 O u0 p2 c0  {1,S} {15,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15 *2 H u0 p0 c0  {5,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {4,S} {10,S} {11,S} {12,S}
4  *3 C u1 p0 c0  {1,S} {3,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.286517, 'd12': 1.264185, 'd13': 2.546171},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 140,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 O u1 p2 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3  *1 C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 O u0 p2 c0  {1,S} {15,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15 *2 H u0 p0 c0  {5,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {2,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.247176, 'd12': 1.284317, 'd13': 2.529051},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 141,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *1 C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     C u0 p0 c0  {1,S} {15,S} {16,S} {17,S}
6     C u0 p0 c0  {2,S} {18,S} {19,S} {20,S}
7     C u0 p0 c0  {2,S} {21,S} {22,S} {23,S}
8     C u0 p0 c0  {2,S} {24,S} {25,S} {26,S}
9  *2 H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {6,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {7,S}
24    H u0 p0 c0  {8,S}
25    H u0 p0 c0  {8,S}
26    H u0 p0 c0  {8,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {15,S} {16,S} {17,S}
4     C u0 p0 c0  {1,S} {18,S} {19,S} {20,S}
5     C u0 p0 c0  {1,S} {21,S} {22,S} {23,S}
6     C u0 p0 c0  {2,S} {9,S} {10,S} {11,S}
7     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
8  *3 C u1 p0 c0  {2,S} {24,S} {25,S}
9     H u0 p0 c0  {6,S}
10    H u0 p0 c0  {6,S}
11    H u0 p0 c0  {6,S}
12    H u0 p0 c0  {7,S}
13    H u0 p0 c0  {7,S}
14    H u0 p0 c0  {7,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {3,S}
17    H u0 p0 c0  {3,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {4,S}
20    H u0 p0 c0  {4,S}
21    H u0 p0 c0  {5,S}
22    H u0 p0 c0  {5,S}
23    H u0 p0 c0  {5,S}
24    H u0 p0 c0  {8,S}
25    H u0 p0 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.379587, 'd12': 1.333337, 'd13': 2.706613},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 142,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     C u0 p0 c0  {1,S} {15,S} {16,S} {17,S}
6     O u0 p2 c0  {2,S} {18,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18 *3 O u1 p2 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u1 p2 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {1,S} {16,S} {17,S} {18,S}
6     O u0 p2 c0  {2,S} {7,S}
7  *1 O u0 p2 c0  {6,S} {19,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19 *2 H u0 p0 c0  {7,S}
""",
    product2 = """
multiplicity 3
1 *3 O u1 p2 c0  {2,S}
2    O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.345438, 'd12': 1.094942, 'd13': 2.436127},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 143,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     O u0 p2 c0  {1,S} {15,S}
6     O u0 p2 c0  {2,S} {16,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16 *3 O u1 p2 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u1 p2 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {5,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     O u0 p2 c0  {2,S} {7,S}
6     O u0 p2 c0  {1,S} {16,S}
7  *1 O u0 p2 c0  {5,S} {17,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {6,S}
17 *2 H u0 p0 c0  {7,S}
""",
    product2 = """
multiplicity 3
1 *3 O u1 p2 c0  {2,S}
2    O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.420877, 'd12': 1.060269, 'd13': 2.465326},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 144,
    reactant1 = """
multiplicity 2
1 *1 O u0 p2 c0  {2,S} {3,S}
2 *2 H u0 p0 c0  {1,S}
3    O u1 p2 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {5,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {6,S} {11,S} {12,S}
4     C u0 p0 c0  {5,S} {6,S} {13,S} {14,S}
5     C u0 p0 c0  {2,S} {4,S} {15,S} {16,S}
6     C u0 p0 c0  {3,S} {4,S} {17,S} {18,S}
7     O u0 p2 c0  {1,S} {19,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {6,S}
18    H u0 p0 c0  {6,S}
19 *3 O u1 p2 c0  {7,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {9,S}
2     C u0 p0 c0  {1,S} {4,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {5,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {6,S} {14,S} {15,S}
5     C u0 p0 c0  {3,S} {6,S} {16,S} {17,S}
6     C u0 p0 c0  {4,S} {5,S} {18,S} {19,S}
7     O u0 p2 c0  {1,S} {8,S}
8  *1 O u0 p2 c0  {7,S} {20,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {6,S}
19    H u0 p0 c0  {6,S}
20 *2 H u0 p0 c0  {8,S}
""",
    product2 = """
multiplicity 3
1 *3 O u1 p2 c0  {2,S}
2    O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.405068, 'd12': 1.066347, 'd13': 2.461135},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 145,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {5,S} {9,S}
2     C u0 p0 c0  {6,S} {7,S} {8,S} {10,S}
3  *1 C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {2,S} {23,S} {24,S} {25,S}
8     C u0 p0 c0  {2,S} {26,S} {27,S} {28,S}
9     O u0 p2 c0  {1,S} {10,S}
10    O u0 p2 c0  {2,S} {9,S}
11 *2 H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    H u0 p0 c0  {7,S}
24    H u0 p0 c0  {7,S}
25    H u0 p0 c0  {7,S}
26    H u0 p0 c0  {8,S}
27    H u0 p0 c0  {8,S}
28    H u0 p0 c0  {8,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {9,S}
2     C u0 p0 c0  {6,S} {7,S} {8,S} {10,S}
3     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
4     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
5     C u0 p0 c0  {1,S} {23,S} {24,S} {25,S}
6     C u0 p0 c0  {2,S} {11,S} {12,S} {13,S}
7     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
8  *3 C u1 p0 c0  {2,S} {26,S} {27,S}
9     O u0 p2 c0  {1,S} {10,S}
10    O u0 p2 c0  {2,S} {9,S}
11    H u0 p0 c0  {6,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {7,S}
15    H u0 p0 c0  {7,S}
16    H u0 p0 c0  {7,S}
17    H u0 p0 c0  {3,S}
18    H u0 p0 c0  {3,S}
19    H u0 p0 c0  {3,S}
20    H u0 p0 c0  {4,S}
21    H u0 p0 c0  {4,S}
22    H u0 p0 c0  {4,S}
23    H u0 p0 c0  {5,S}
24    H u0 p0 c0  {5,S}
25    H u0 p0 c0  {5,S}
26    H u0 p0 c0  {8,S}
27    H u0 p0 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.362866, 'd12': 1.339148, 'd13': 2.70112},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 146,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {8,S}
2     C u0 p0 c0  {1,B} {4,B} {7,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,D} {8,S}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4     C u0 p0 c0  {2,D} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6  *2 H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3  *1 C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1  *3 C u1 p0 c0  {2,S} {3,S} {6,S}
2     C u0 p0 c0  {1,S} {4,D} {7,S}
3     C u0 p0 c0  {1,S} {5,D} {8,S}
4     C u0 p0 c0  {2,D} {5,S} {9,S}
5     C u0 p0 c0  {3,D} {4,S} {10,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {4,S}
10    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.585963, 'd12': 1.207705, 'd13': 2.793668},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 147,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 O u1 p2 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {5,S} {7,S} {8,S} {9,S}
2     C u0 p0 c0  {5,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {6,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {1,S} {2,S} {6,D}
6     C u0 p0 c0  {3,S} {4,S} {5,D}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 O u0 p2 c0  {1,S} {15,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15 *2 H u0 p0 c0  {5,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {10,S} {11,S} {12,S}
2     C u0 p0 c0  {4,S} {13,S} {14,S} {15,S}
3     C u0 p0 c0  {5,S} {7,S} {8,S} {9,S}
4     C u0 p0 c0  {1,S} {2,S} {5,D}
5     C u0 p0 c0  {3,S} {4,D} {6,S}
6  *3 C u1 p0 c0  {5,S} {16,S} {17,S}
7     H u0 p0 c0  {3,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {1,S}
13    H u0 p0 c0  {2,S}
14    H u0 p0 c0  {2,S}
15    H u0 p0 c0  {2,S}
16    H u0 p0 c0  {6,S}
17    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.387594, 'd12': 1.217391, 'd13': 2.604205},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 148,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {8,S} {9,S} {10,S}
2     C u0 p0 c0  {1,S} {3,B} {4,B}
3     C u0 p0 c0  {2,B} {5,B} {12,S}
4     C u0 p0 c0  {2,B} {7,B} {15,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {5,B} {7,B} {13,S}
7     C u0 p0 c0  {4,B} {6,B} {14,S}
8     O u0 p2 c0  {1,S} {16,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {7,S}
15    H u0 p0 c0  {4,S}
16 *3 O u1 p2 c0  {8,S}
""",
    reactant2 = """
multiplicity 2
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u1 p2 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {8,S} {10,S} {11,S}
2     C u0 p0 c0  {1,S} {3,B} {4,B}
3     C u0 p0 c0  {2,B} {5,B} {13,S}
4     C u0 p0 c0  {2,B} {7,B} {16,S}
5     C u0 p0 c0  {3,B} {6,B} {12,S}
6     C u0 p0 c0  {5,B} {7,B} {14,S}
7     C u0 p0 c0  {4,B} {6,B} {15,S}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {17,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {6,S}
15    H u0 p0 c0  {7,S}
16    H u0 p0 c0  {4,S}
17 *2 H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 3
1 *3 O u1 p2 c0  {2,S}
2    O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.374965, 'd12': 1.076901, 'd13': 2.450556},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 149,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.301073, 'd12': 1.423371, 'd13': 2.724135},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 150,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    distances = DistanceData(
        distances = {'d23': 1.310432, 'd12': 0.972136, 'd13': 2.282304},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 151,
    reactant1 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 O u1 p2 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1    H u0 p0 c0  {2,S}
2 *3 O u1 p2 c0  {1,S}
""",
    product2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.052469, 'd12': 1.341712, 'd13': 2.29163},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 152,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.544596, 'd12': 1.233914, 'd13': 2.77851},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 153,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,D}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,D}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    O u0 p2 c0  {1,D}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.34342, 'd12': 1.412594, 'd13': 2.737275},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 154,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.33285, 'd12': 1.392257, 'd13': 2.724149},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 155,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,D}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,D}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    O u0 p2 c0  {1,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.305805, 'd12': 1.44735, 'd13': 2.751257},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 156,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.411619, 'd12': 1.287052, 'd13': 2.698415},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 157,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.496988, 'd12': 1.275252, 'd13': 2.771865},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 158,
    reactant1 = """
1    O u0 p2 c0  {2,S} {3,S}
2 *1 O u0 p2 c0  {1,S} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    product2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.328593, 'd12': 1.219969, 'd13': 2.518475},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 159,
    reactant1 = """
1    O u0 p2 c0  {2,S} {3,S}
2 *1 O u0 p2 c0  {1,S} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    product2 = """
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *1 C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6 *2 H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48334, 'd12': 1.086921, 'd13': 2.569676},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 160,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1    C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2 *1 C u0 p0 c0  {3,S} {7,D} {8,S}
3    O u0 p2 c0  {1,S} {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8 *2 H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    O u0 p2 c0  {1,S} {3,S}
3 *3 C u1 p0 c0  {2,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 0.97841, 'd12': 1.320296, 'd13': 2.298176},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 161,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *3 O u1 p2 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    O u0 p2 c0  {1,S} {3,S}
3 *1 O u0 p2 c0  {2,S} {7,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7 *2 H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.190105, 'd12': 1.355419, 'd13': 2.545508},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 162,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.386526, 'd12': 1.395629, 'd13': 2.782155},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 163,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.345537, 'd12': 1.41706, 'd13': 2.734548},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 164,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.357681, 'd12': 1.371076, 'd13': 2.727624},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 165,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.334129, 'd12': 1.394987, 'd13': 2.727829},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 166,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.408956, 'd12': 1.288945, 'd13': 2.697672},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 167,
    reactant1 = """
multiplicity 3
1    O u1 p2 c0  {2,S}
2 *3 O u1 p2 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
multiplicity 2
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u1 p2 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.056332, 'd12': 1.660094, 'd13': 2.716154},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 168,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.455887, 'd12': 1.307194, 'd13': 2.761316},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 169,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.418259, 'd12': 1.316115, 'd13': 2.721717},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 170,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,D}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,D}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    O u0 p2 c0  {1,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.395046, 'd12': 1.351556, 'd13': 2.746143},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 171,
    reactant1 = """
1    O u0 p2 c0  {2,S} {3,S}
2 *1 O u0 p2 c0  {1,S} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    product2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.304434, 'd12': 1.245948, 'd13': 2.550214},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 172,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {4,D} {11,S}
4     C u0 p0 c0  {2,S} {3,D} {12,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,D} {8,S}
3     C u0 p0 c0  {2,D} {4,S} {9,S}
4  *3 C u1 p0 c0  {3,S} {10,S} {11,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.476903, 'd12': 1.264341, 'd13': 2.740492},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 173,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.334801, 'd12': 1.383413, 'd13': 2.718214},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 174,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *3 O u1 p2 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    O u0 p2 c0  {1,S} {3,S}
3 *1 O u0 p2 c0  {2,S} {7,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7 *2 H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.176561, 'd12': 1.371259, 'd13': 2.547001},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 175,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *3 O u1 p2 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    O u0 p2 c0  {1,S} {3,S}
3 *1 O u0 p2 c0  {2,S} {7,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7 *2 H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.151769, 'd12': 1.402633, 'd13': 2.553686},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 176,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.358629, 'd12': 1.395402, 'd13': 2.751896},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 177,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {1,S} {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.378691, 'd12': 1.352975, 'd13': 2.731071},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 178,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.332454, 'd12': 1.396635, 'd13': 2.72898},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 179,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,D}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,D}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    O u0 p2 c0  {1,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {1,S} {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.349393, 'd12': 1.400777, 'd13': 2.748536},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 180,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.410103, 'd12': 1.295021, 'd13': 2.703918},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 181,
    reactant1 = """
multiplicity 3
1    O u1 p2 c0  {2,S}
2 *3 O u1 p2 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
multiplicity 2
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u1 p2 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {1,S} {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.075459, 'd12': 1.603839, 'd13': 2.678774},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 182,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *1 C u0 p0 c0  {1,S} {12,D} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    O u0 p2 c0  {4,D}
13 *2 H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.502489, 'd12': 1.275561, 'd13': 2.776544},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 183,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.422416, 'd12': 1.307104, 'd13': 2.729321},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 184,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.443078, 'd12': 1.291611, 'd13': 2.733904},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 185,
    reactant1 = """
multiplicity 3
1    O u1 p2 c0  {2,S}
2 *3 O u1 p2 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,S} {12,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
""",
    product1 = """
multiplicity 2
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u1 p2 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,S} {11,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.12593, 'd12': 1.494936, 'd13': 2.619254},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 186,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *1 C u0 p0 c0  {1,S} {9,D} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     O u0 p2 c0  {3,D}
10 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *3 C u1 p0 c0  {1,S} {9,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.460727, 'd12': 1.307047, 'd13': 2.76402},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 187,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *1 C u0 p0 c0  {2,S} {12,D} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    O u0 p2 c0  {4,D}
13 *2 H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {2,S} {12,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.503366, 'd12': 1.274549, 'd13': 2.776775},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 188,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {3,S} {6,S} {7,S}
3     C u0 p0 c0  {1,S} {2,S} {8,S} {9,S}
4  *1 C u0 p0 c0  {1,S} {10,D} {11,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
11 *2 H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {3,S} {6,S} {7,S}
3     C u0 p0 c0  {1,S} {2,S} {8,S} {9,S}
4  *3 C u1 p0 c0  {1,S} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.499708, 'd12': 1.280838, 'd13': 2.777508},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 189,
    reactant1 = """
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,D} {8,S}
3     C u0 p0 c0  {2,D} {4,S} {9,S}
4  *1 C u0 p0 c0  {3,S} {10,D} {11,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
11 *2 H u0 p0 c0  {4,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,D} {8,S}
3     C u0 p0 c0  {2,D} {4,S} {9,S}
4  *3 C u1 p0 c0  {3,S} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    product2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.490125, 'd12': 1.281734, 'd13': 2.768809},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 190,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 O u1 p2 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 O u0 p2 c0  {1,S} {15,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15 *2 H u0 p0 c0  {5,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.369307, 'd12': 1.213795, 'd13': 2.578224},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 191,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {8,S}
2     C u0 p0 c0  {1,B} {4,B} {7,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2  *1 C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8  *2 H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.381618, 'd12': 1.303803, 'd13': 2.685418},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 192,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.339219, 'd12': 1.386573, 'd13': 2.724421},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 193,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8  *2 H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {1,S} {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.40752, 'd12': 1.324029, 'd13': 2.729261},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 194,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {7,S} {8,S}
3 *1 C u0 p0 c0  {1,S} {5,D} {6,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {3,D}
6 *2 H u0 p0 c0  {3,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.419813, 'd12': 1.341631, 'd13': 2.752365},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 195,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {6,S} {13,S} {14,S}
5     C u0 p0 c0  {3,S} {6,S} {15,S} {16,S}
6     C u0 p0 c0  {4,S} {5,S} {17,S} {18,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {6,S}
18    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {11,S} {12,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {5,S} {9,S} {10,S}
4     C u0 p0 c0  {2,S} {6,S} {13,S} {14,S}
5     C u0 p0 c0  {3,S} {6,S} {15,S} {16,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {17,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {1,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.409078, 'd12': 1.300082, 'd13': 2.708894},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 196,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {1,S} {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.404289, 'd12': 1.322631, 'd13': 2.726413},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 197,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,D}
3 *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,D}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.406087, 'd12': 1.314745, 'd13': 2.715634},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 198,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {5,S} {7,S} {8,S} {9,S}
2     C u0 p0 c0  {5,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {6,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {1,S} {2,S} {6,D}
6     C u0 p0 c0  {3,S} {4,S} {5,D}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {10,S} {11,S} {12,S}
2     C u0 p0 c0  {4,S} {13,S} {14,S} {15,S}
3     C u0 p0 c0  {5,S} {7,S} {8,S} {9,S}
4     C u0 p0 c0  {1,S} {2,S} {5,D}
5     C u0 p0 c0  {3,S} {4,D} {6,S}
6  *3 C u1 p0 c0  {5,S} {16,S} {17,S}
7     H u0 p0 c0  {3,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {1,S}
13    H u0 p0 c0  {2,S}
14    H u0 p0 c0  {2,S}
15    H u0 p0 c0  {2,S}
16    H u0 p0 c0  {6,S}
17    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.481921, 'd12': 1.265173, 'd13': 2.746184},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 199,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {5,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 C u0 p0 c0  {2,S} {15,D} {16,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    O u0 p2 c0  {5,D}
16 *2 H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {5,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 C u1 p0 c0  {2,S} {15,D}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    O u0 p2 c0  {5,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.502992, 'd12': 1.273234, 'd13': 2.775786},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 200,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4  *1 C u0 p0 c0  {5,S} {13,D} {14,S}
5     O u0 p2 c0  {1,S} {4,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {4,D}
14 *2 H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     O u0 p2 c0  {1,S} {5,S}
5  *3 C u1 p0 c0  {4,S} {13,D}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {5,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.411288, 'd12': 1.31096, 'd13': 2.722246},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 201,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 C u0 p0 c0  {1,S} {15,D} {16,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    O u0 p2 c0  {5,D}
16 *2 H u0 p0 c0  {5,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 C u1 p0 c0  {1,S} {15,D}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    O u0 p2 c0  {5,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.504782, 'd12': 1.277167, 'd13': 2.778712},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 202,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {8,S}
2     C u0 p0 c0  {1,B} {4,B} {7,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3  *1 C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.422491, 'd12': 1.279787, 'd13': 2.702277},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 203,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *1 C u0 p0 c0  {1,S} {12,D} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    O u0 p2 c0  {4,D}
13 *2 H u0 p0 c0  {4,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.433791, 'd12': 1.331086, 'd13': 2.759466},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 204,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 O u1 p2 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 O u0 p2 c0  {1,S} {15,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15 *2 H u0 p0 c0  {5,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.344864, 'd12': 1.232721, 'd13': 2.576968},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 205,
    reactant1 = """
multiplicity 3
1    O u1 p2 c0  {2,S}
2 *3 O u1 p2 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,D} {11,S}
4     C u0 p0 c0  {2,S} {6,D} {12,S}
5     C u0 p0 c0  {3,D} {6,S} {13,S}
6     C u0 p0 c0  {4,D} {5,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {5,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
multiplicity 2
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u1 p2 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *3 C u1 p0 c0  {1,S} {4,S} {9,S}
3     C u0 p0 c0  {1,S} {5,D} {10,S}
4     C u0 p0 c0  {2,S} {6,D} {11,S}
5     C u0 p0 c0  {3,D} {6,S} {13,S}
6     C u0 p0 c0  {4,D} {5,S} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.189731, 'd12': 1.417057, 'd13': 2.604216},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 206,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *1 C u0 p0 c0  {2,S} {12,D} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    O u0 p2 c0  {4,D}
13 *2 H u0 p0 c0  {4,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {2,S} {12,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.461026, 'd12': 1.308636, 'd13': 2.768538},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 207,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2  *3 C u1 p0 c0  {1,S} {3,S} {8,S}
3     C u0 p0 c0  {2,S} {4,D} {9,S}
4     C u0 p0 c0  {3,D} {10,S} {11,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {4,D} {11,S}
4     C u0 p0 c0  {2,S} {3,D} {12,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {4,D} {10,S}
4     C u0 p0 c0  {3,D} {11,S} {12,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,D} {8,S}
3     C u0 p0 c0  {2,D} {4,S} {9,S}
4  *3 C u1 p0 c0  {3,S} {10,S} {11,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35724, 'd12': 1.3751, 'd13': 2.73016},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 208,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 O u1 p2 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,S} {12,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 O u0 p2 c0  {1,S} {15,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15 *2 H u0 p0 c0  {5,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,S} {11,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.339756, 'd12': 1.236844, 'd13': 2.575745},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 209,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {8,S}
2     C u0 p0 c0  {1,B} {4,B} {7,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {3,D} {4,S} {5,S}
2    C u0 p0 c0  {3,D} {6,S} {7,S}
3    C u0 p0 c0  {1,D} {2,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3  *1 C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {4,S} {5,S}
2    C u0 p0 c0  {1,D} {3,D}
3 *3 C u1 p0 c0  {2,D} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.465935, 'd12': 1.240011, 'd13': 2.705301},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 210,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {5,S} {7,S} {8,S} {9,S}
2     C u0 p0 c0  {5,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {6,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {1,S} {2,S} {6,D}
6     C u0 p0 c0  {3,S} {4,S} {5,D}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {10,S} {11,S} {12,S}
2     C u0 p0 c0  {4,S} {13,S} {14,S} {15,S}
3     C u0 p0 c0  {5,S} {7,S} {8,S} {9,S}
4     C u0 p0 c0  {1,S} {2,S} {5,D}
5     C u0 p0 c0  {3,S} {4,D} {6,S}
6  *3 C u1 p0 c0  {5,S} {16,S} {17,S}
7     H u0 p0 c0  {3,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {1,S}
13    H u0 p0 c0  {2,S}
14    H u0 p0 c0  {2,S}
15    H u0 p0 c0  {2,S}
16    H u0 p0 c0  {6,S}
17    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.426374, 'd12': 1.310685, 'd13': 2.73602},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 211,
    reactant1 = """
multiplicity 2
1    H u0 p0 c0  {2,S}
2 *3 O u1 p2 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {1,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7  *1 C u0 p0 c0  {2,S} {12,S} {22,S} {23,S}
8     C u0 p0 c0  {2,S} {24,S} {25,S} {26,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12 *2 H u0 p0 c0  {7,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {7,S}
24    H u0 p0 c0  {8,S}
25    H u0 p0 c0  {8,S}
26    H u0 p0 c0  {8,S}
""",
    product1 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     C u0 p0 c0  {1,S} {15,S} {16,S} {17,S}
6     C u0 p0 c0  {1,S} {18,S} {19,S} {20,S}
7     C u0 p0 c0  {2,S} {21,S} {22,S} {23,S}
8  *3 C u1 p0 c0  {2,S} {24,S} {25,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {6,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {7,S}
24    H u0 p0 c0  {8,S}
25    H u0 p0 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.467679, 'd12': 1.165923, 'd13': 2.632605},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 212,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {5,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4  *3 C u1 p0 c0  {2,S} {13,S} {14,S}
5     O u0 p2 c0  {1,S} {2,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {5,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     O u0 p2 c0  {1,S} {2,S}
6  *2 H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {5,S} {8,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     O u0 p2 c0  {1,S} {2,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12 *2 H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {3,S} {5,S} {14,S}
5     O u0 p2 c0  {1,S} {4,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.440032, 'd12': 1.307357, 'd13': 2.743703},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 213,
    reactant1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {9,S} {10,S}
2  *1 C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
3     C u0 p0 c0  {1,S} {4,B} {5,B}
4     C u0 p0 c0  {3,B} {7,B} {14,S}
5     C u0 p0 c0  {3,B} {8,B} {15,S}
6     C u0 p0 c0  {7,B} {8,B} {16,S}
7     C u0 p0 c0  {4,B} {6,B} {17,S}
8     C u0 p0 c0  {5,B} {6,B} {18,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {2,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {6,S}
17    H u0 p0 c0  {7,S}
18    H u0 p0 c0  {8,S}
""",
    product1 = """
1    O u0 p2 c0  {2,S} {3,S}
2 *1 O u0 p2 c0  {1,S} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {8,S} {9,S} {10,S}
2     C u0 p0 c0  {1,S} {3,B} {4,B}
3     C u0 p0 c0  {2,B} {6,B} {11,S}
4     C u0 p0 c0  {2,B} {7,B} {12,S}
5     C u0 p0 c0  {6,B} {7,B} {13,S}
6     C u0 p0 c0  {3,B} {5,B} {14,S}
7     C u0 p0 c0  {4,B} {5,B} {15,S}
8  *3 C u1 p0 c0  {1,S} {16,S} {17,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {5,S}
14    H u0 p0 c0  {6,S}
15    H u0 p0 c0  {7,S}
16    H u0 p0 c0  {8,S}
17    H u0 p0 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.155233, 'd12': 1.389889, 'd13': 2.544901},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 214,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {2,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5  *1 C u0 p0 c0  {3,S} {15,D} {16,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    O u0 p2 c0  {5,D}
16 *2 H u0 p0 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3  *1 C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11 *2 H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5  *3 C u1 p0 c0  {3,S} {15,D}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    O u0 p2 c0  {5,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.463798, 'd12': 1.308541, 'd13': 2.77175},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 215,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {1,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {5,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 C u0 p0 c0  {2,S} {15,D} {16,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    O u0 p2 c0  {5,D}
16 *2 H u0 p0 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {5,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 C u1 p0 c0  {2,S} {15,D}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    O u0 p2 c0  {5,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.470008, 'd12': 1.299677, 'd13': 2.765791},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 216,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {1,S} {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 C u0 p0 c0  {1,S} {15,D} {16,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    O u0 p2 c0  {5,D}
16 *2 H u0 p0 c0  {5,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 C u1 p0 c0  {1,S} {15,D}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    O u0 p2 c0  {5,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.419633, 'd12': 1.355331, 'd13': 2.757765},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 217,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 O u1 p2 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {6,S} {13,S} {14,S}
5     C u0 p0 c0  {3,S} {6,S} {15,S} {16,S}
6     C u0 p0 c0  {4,S} {5,S} {17,S} {18,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {6,S}
18    H u0 p0 c0  {6,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 O u0 p2 c0  {1,S} {15,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15 *2 H u0 p0 c0  {5,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {11,S} {12,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {5,S} {9,S} {10,S}
4     C u0 p0 c0  {2,S} {6,S} {13,S} {14,S}
5     C u0 p0 c0  {3,S} {6,S} {15,S} {16,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {17,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {1,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.289507, 'd12': 1.256038, 'd13': 2.542827},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 218,
    reactant1 = """
multiplicity 3
1    O u1 p2 c0  {2,S}
2 *3 O u1 p2 c0  {1,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product1 = """
multiplicity 2
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u1 p2 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.084727, 'd12': 1.599845, 'd13': 2.632605},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 219,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *3 O u1 p2 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    O u0 p2 c0  {1,S} {3,S}
3 *1 O u0 p2 c0  {2,S} {7,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7 *2 H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.207728, 'd12': 1.343942, 'd13': 2.52238},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 220,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.447046, 'd12': 1.268698, 'd13': 2.715651},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 221,
    reactant1 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3  *1 C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {12,S} {13,S} {14,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1    O u0 p2 c0  {2,S} {3,S}
2 *1 O u0 p2 c0  {1,S} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *3 C u1 p0 c0  {2,S} {12,S} {13,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.157061, 'd12': 1.387852, 'd13': 2.544644},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 222,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3  *1 C u0 p0 c0  {4,S} {10,D} {11,S}
4     O u0 p2 c0  {1,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
11 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     O u0 p2 c0  {1,S} {4,S}
4  *3 C u1 p0 c0  {3,S} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.400219, 'd12': 1.317411, 'd13': 2.717538},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 223,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3  *1 C u0 p0 c0  {4,S} {10,D} {11,S}
4     O u0 p2 c0  {1,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
11 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {5,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     O u0 p2 c0  {1,S} {4,S}
4  *3 C u1 p0 c0  {3,S} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.369407, 'd12': 1.350874, 'd13': 2.720067},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 224,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {5,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4  *1 C u0 p0 c0  {5,S} {13,D} {14,S}
5     O u0 p2 c0  {2,S} {4,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {4,D}
14 *2 H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     O u0 p2 c0  {2,S} {5,S}
5  *3 C u1 p0 c0  {4,S} {13,D}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {5,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.401544, 'd12': 1.316801, 'd13': 2.718293},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 225,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {8,S}
2     C u0 p0 c0  {1,B} {4,B} {7,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,S} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {2,S} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3  *1 C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,S} {6,S} {7,S}
3 *3 C u1 p0 c0  {1,S} {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.368342, 'd12': 1.301866, 'd13': 2.670175},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 226,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 O u1 p2 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {4,D} {11,S}
4     C u0 p0 c0  {2,S} {3,D} {12,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 O u0 p2 c0  {1,S} {15,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15 *2 H u0 p0 c0  {5,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,D} {8,S}
3     C u0 p0 c0  {2,D} {4,S} {9,S}
4  *3 C u1 p0 c0  {3,S} {10,S} {11,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.366807, 'd12': 1.223685, 'd13': 2.589608},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 227,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {8,S}
2     C u0 p0 c0  {1,B} {4,B} {7,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2  *1 C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8  *2 H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {4,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {4,S} {11,S} {12,S} {13,S}
4  *3 C u1 p0 c0  {1,S} {2,S} {3,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.49714, 'd12': 1.244105, 'd13': 2.741235},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 228,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *3 O u1 p2 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {4,S} {6,S} {7,S} {8,S}
2     C u0 p0 c0  {4,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {5,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {1,S} {2,S} {5,D}
5     C u0 p0 c0  {3,S} {4,D} {15,S}
6  *2 H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
5  *1 O u0 p2 c0  {1,S} {15,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15 *2 H u0 p0 c0  {5,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {8,S}
2     C u0 p0 c0  {4,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {4,D} {5,S}
4     C u0 p0 c0  {2,S} {3,D} {12,S}
5  *3 C u1 p0 c0  {3,S} {13,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {5,S}
14    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.365815, 'd12': 1.22576, 'd13': 2.590913},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 229,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {8,S}
2     C u0 p0 c0  {1,B} {4,B} {7,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {5,S} {12,S} {13,S}
5     C u0 p0 c0  {3,S} {4,S} {14,S} {15,S}
6  *2 H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {5,S}
15    H u0 p0 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3  *1 C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {4,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {5,S} {10,S} {11,S}
4     C u0 p0 c0  {2,S} {5,S} {12,S} {13,S}
5  *3 C u1 p0 c0  {3,S} {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {4,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.475176, 'd12': 1.2474, 'd13': 2.722152},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 230,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {8,S}
2     C u0 p0 c0  {1,B} {4,B} {7,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {6,S} {13,S} {14,S}
5     C u0 p0 c0  {3,S} {6,S} {15,S} {16,S}
6     C u0 p0 c0  {4,S} {5,S} {17,S} {18,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {6,S}
18    H u0 p0 c0  {6,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2  *1 C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8  *2 H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {11,S} {12,S}
2     C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {5,S} {9,S} {10,S}
4     C u0 p0 c0  {2,S} {6,S} {13,S} {14,S}
5     C u0 p0 c0  {3,S} {6,S} {15,S} {16,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {17,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {1,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {5,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.460601, 'd12': 1.257363, 'd13': 2.717863},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 231,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6  *1 C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21 *2 H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.4645, 'd12': 1.28515, 'd13': 2.74755},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 232,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10 *2 H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39584, 'd12': 1.15497, 'd13': 2.55035},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 233,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.33923, 'd12': 1.22246, 'd13': 2.55653},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 234,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10 *2 H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4027, 'd12': 1.1524, 'd13': 2.5549},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 235,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.33965, 'd12': 1.22029, 'd13': 2.55515},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 236,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.14693, 'd12': 1.05778, 'd13': 2.2018},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 237,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.3615, 'd12': 1.19277, 'd13': 2.55206},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 238,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.36537, 'd12': 1.18793, 'd13': 2.55312},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 239,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.04802, 'd12': 1.24975, 'd13': 2.29631},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 240,
    reactant1 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u0 p2 c0  {1,S} {4,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2 *3 O u1 p2 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.34472, 'd12': 1.20093, 'd13': 2.54466},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 241,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *1 C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.56172, 'd12': 1.21958, 'd13': 2.77843},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 242,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10 *2 H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *1 C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.40437, 'd12': 1.29438, 'd13': 2.69639},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 243,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.54692, 'd12': 1.06429, 'd13': 2.61094},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 244,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u0 p2 c0  {1,S} {4,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *1 C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.51251, 'd12': 1.07478, 'd13': 2.58617},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 245,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *1 C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.49915, 'd12': 1.23899, 'd13': 2.73813},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 246,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6  *1 C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21 *2 H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.43931, 'd12': 1.29223, 'd13': 2.73106},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 247,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.3563, 'd12': 1.3751, 'd13': 2.7299},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 248,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.32493, 'd12': 1.23524, 'd13': 2.55853},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 249,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.32662, 'd12': 1.23227, 'd13': 2.55831},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 250,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {10,S}
5     C u0 p0 c0  {3,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u1 p2 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {9,S} {10,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 3
1 *3 O u1 p2 c0  {2,S}
2    O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.43796, 'd12': 1.16929, 'd13': 2.60307},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 251,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u1 p2 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 3
1 *3 O u1 p2 c0  {2,S}
2    O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48877, 'd12': 1.13195, 'd13': 2.61754},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 252,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.36627, 'd12': 1.36997, 'd13': 2.72492},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 253,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {10,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.28842, 'd12': 1.2841, 'd13': 2.57085},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 254,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.30648, 'd12': 1.25665, 'd13': 2.55165},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 255,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {10,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {10,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.29098, 'd12': 1.28233, 'd13': 2.57282},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 256,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.31291, 'd12': 1.24693, 'd13': 2.55976},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 257,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {10,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.21398, 'd12': 1.18161, 'd13': 2.3926},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 258,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.14566, 'd12': 1.19861, 'd13': 2.34236},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 259,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2 *3 O u1 p2 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
1    O u0 p2 c0  {2,S} {3,S}
2 *1 O u0 p2 c0  {1,S} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.2645, 'd12': 1.29127, 'd13': 2.55403},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 260,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {10,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4317, 'd12': 1.30678, 'd13': 2.73707},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 261,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39513, 'd12': 1.32678, 'd13': 2.72178},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 262,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {10,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4003, 'd12': 1.33276, 'd13': 2.73048},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 263,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.36925, 'd12': 1.35932, 'd13': 2.72635},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 264,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11 *2 H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.52025, 'd12': 1.25472, 'd13': 2.77157},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 265,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42535, 'd12': 1.31715, 'd13': 2.74206},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 266,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42188, 'd12': 1.31943, 'd13': 2.74058},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 267,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {10,S}
5     C u0 p0 c0  {3,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39787, 'd12': 1.35642, 'd13': 2.75277},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 268,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10 *2 H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {1,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {2,S} {10,S} {11,S} {12,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.3949, 'd12': 1.30496, 'd13': 2.69921},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 269,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.54499, 'd12': 1.22688, 'd13': 2.76811},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 270,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.49453, 'd12': 1.08536, 'd13': 2.57808},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 271,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *1 C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.34372, 'd12': 1.32515, 'd13': 2.66858},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 272,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {10,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.58064, 'd12': 1.21013, 'd13': 2.78913},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 273,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.63621, 'd12': 1.19456, 'd13': 2.8296},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 274,
    reactant1 = """
1 *1 C u0 p0 c0  {3,D} {4,S} {5,S}
2    C u0 p0 c0  {3,D} {6,S} {7,S}
3    C u0 p0 c0  {1,D} {2,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 3
1 *3 O u2 p2 c0 
""",
    product1 = """
multiplicity 2
1 *1 O u1 p2 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {4,S} {5,S}
2    C u0 p0 c0  {1,D} {3,D}
3 *3 C u1 p0 c0  {2,D} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.30104, 'd12': 1.22872, 'd13': 2.52774},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 275,
    reactant1 = """
1 *1 C u0 p0 c0  {3,D} {4,S} {5,S}
2    C u0 p0 c0  {3,D} {6,S} {7,S}
3    C u0 p0 c0  {1,D} {2,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {4,S} {5,S}
2    C u0 p0 c0  {1,D} {3,D}
3 *3 C u1 p0 c0  {2,D} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.45271, 'd12': 1.2474, 'd13': 2.69994},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 276,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48384, 'd12': 1.24755, 'd13': 2.73092},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 277,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,T} {3,S}
2 *3 C u1 p0 c0  {1,T}
3    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,B} {6,B} {7,S}
2     C u0 p0 c0  {1,B} {3,B} {8,S}
3     C u0 p0 c0  {2,B} {4,B} {9,S}
4     C u0 p0 c0  {3,B} {5,B} {10,S}
5     C u0 p0 c0  {4,B} {6,B} {11,S}
6     C u0 p0 c0  {1,B} {5,B} {12,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product1 = """
1    C u0 p0 c0  {2,T} {3,S}
2 *1 C u0 p0 c0  {1,T} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {8,S}
2     C u0 p0 c0  {1,B} {4,B} {7,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.7883, 'd12': 1.11822, 'd13': 2.72249},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 278,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,T} {3,S}
2 *3 C u1 p0 c0  {1,T}
3    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1    C u0 p0 c0  {2,T} {3,S}
2 *1 C u0 p0 c0  {1,T} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.83906, 'd12': 1.15005, 'd13': 2.8339},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 279,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3 *1 C u0 p0 c0  {2,D} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *1 C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3 *3 C u1 p0 c0  {2,D} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.33911, 'd12': 1.32731, 'd13': 2.66614},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 280,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *1 C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7 *2 H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *1 C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {3,D} {7,S} {8,S}
3 *3 C u1 p0 c0  {1,S} {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.38136, 'd12': 1.3002, 'd13': 2.68147},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 281,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4419, 'd12': 1.12041, 'd13': 2.56111},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 282,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {10,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.52157, 'd12': 1.24362, 'd13': 2.76374},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 283,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48582, 'd12': 1.25446, 'd13': 2.73982},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 284,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8  *2 H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.47281, 'd12': 1.28254, 'd13': 2.75245},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 285,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.40491, 'd12': 1.14908, 'd13': 2.55287},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 286,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.40496, 'd12': 1.14979, 'd13': 2.55458},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 287,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {10,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48928, 'd12': 1.26884, 'd13': 2.757},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 288,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.45564, 'd12': 1.27882, 'd13': 2.73397},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 289,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.41597, 'd12': 1.3076, 'd13': 2.72339},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 290,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6  *1 C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21 *2 H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.3921, 'd12': 1.33465, 'd13': 2.71635},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 291,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.4489, 'd12': 1.30203, 'd13': 2.7492},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 292,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.37297, 'd12': 1.17504, 'd13': 2.54771},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 293,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {10,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.46579, 'd12': 1.28126, 'd13': 2.74613},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 294,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42727, 'd12': 1.30178, 'd13': 2.72849},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 295,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.49951, 'd12': 1.2665, 'd13': 2.76595},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 296,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39121, 'd12': 1.3275, 'd13': 2.71845},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 297,
    reactant1 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *1 C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7 *2 H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {3,D} {7,S} {8,S}
3 *3 C u1 p0 c0  {1,S} {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.37145, 'd12': 1.30932, 'd13': 2.68013},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 298,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {4,S}
2    C u0 p0 c0  {1,D} {3,D}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.51956, 'd12': 1.21389, 'd13': 2.73063},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 299,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {4,S}
2    C u0 p0 c0  {1,D} {3,D}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42941, 'd12': 1.12316, 'd13': 2.51147},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 300,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {4,S}
2    C u0 p0 c0  {1,D} {3,D}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    distances = DistanceData(
        distances = {'d23': 1.33968, 'd12': 0.9018, 'd13': 2.22722},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 301,
    reactant1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    reactant2 = """
multiplicity 2
1 *3 O u1 p2 c0  {2,S}
2    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    C u0 p0 c0  {1,D} {4,D}
3    H u0 p0 c0  {1,S}
4    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.30467, 'd12': 1.21817, 'd13': 2.402},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 302,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {4,S}
2    C u0 p0 c0  {1,D} {3,D}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u0 p2 c0  {1,S} {4,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.3887, 'd12': 1.1423, 'd13': 2.49413},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 303,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {4,S}
2    C u0 p0 c0  {1,D} {3,D}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.43653, 'd12': 1.25393, 'd13': 2.68602},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 304,
    reactant1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3  *1 C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    C u0 p0 c0  {1,D} {4,D}
3    H u0 p0 c0  {1,S}
4    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.3766, 'd12': 1.26872, 'd13': 2.64367},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 305,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {4,S}
2    C u0 p0 c0  {1,D} {3,D}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48049, 'd12': 1.23161, 'd13': 2.7063},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 306,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {4,S}
2    C u0 p0 c0  {1,D} {3,D}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.52012, 'd12': 1.21282, 'd13': 2.73203},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 307,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {4,S}
2    C u0 p0 c0  {1,D} {3,D}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.64989, 'd12': 1.18263, 'd13': 2.82623},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 308,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {4,S}
2    C u0 p0 c0  {1,D} {3,D}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.36923, 'd12': 1.28719, 'd13': 2.65352},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 309,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u1 p2 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,D}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    O u0 p2 c0  {1,D}
""",
    product2 = """
multiplicity 3
1 *3 O u1 p2 c0  {2,S}
2    O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.63906, 'd12': 1.06073, 'd13': 2.67112},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 310,
    reactant1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.33681, 'd12': 1.41201, 'd13': 2.74352},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 311,
    reactant1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12 *2 H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.45701, 'd12': 1.29925, 'd13': 2.75322},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 312,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,D} {4,S}
2 *2 H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35579, 'd12': 1.1896, 'd13': 2.54517},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 313,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,D} {4,S}
2 *2 H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.34673, 'd12': 1.19842, 'd13': 2.54512},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 314,
    reactant1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.37871, 'd12': 1.36509, 'd13': 2.7437},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 315,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39566, 'd12': 1.346, 'd13': 2.7406},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 316,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.47435, 'd12': 1.2966, 'd13': 2.77043},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 317,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {10,S}
5     C u0 p0 c0  {3,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.43306, 'd12': 1.31876, 'd13': 2.75032},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 318,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.44466, 'd12': 1.3079, 'd13': 2.74542},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 319,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11 *2 H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.43245, 'd12': 1.31165, 'd13': 2.7418},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 320,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35885, 'd12': 1.1892, 'd13': 2.54765},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 321,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 3
1 *3 O u2 p2 c0 
""",
    product1 = """
multiplicity 2
1 *1 O u1 p2 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35535, 'd12': 1.21905, 'd13': 2.57338},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 322,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.38428, 'd12': 1.34325, 'd13': 2.71004},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 323,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.422, 'd12': 1.31117, 'd13': 2.72112},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 324,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {10,S}
5     C u0 p0 c0  {3,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.46414, 'd12': 1.2927, 'd13': 2.74909},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 325,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10 *2 H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {1,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {2,S} {10,S} {11,S} {12,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.41, 'd12': 1.27717, 'd13': 2.68716},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 326,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.57265, 'd12': 1.20382, 'd13': 2.77343},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 327,
    reactant1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    distances = DistanceData(
        distances = {'d23': 1.49513, 'd12': 0.841684, 'd13': 2.33681},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 328,
    reactant1 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u0 p2 c0  {1,S} {4,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2 *3 O u1 p2 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.5254, 'd12': 1.06245, 'd13': 2.58634},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 329,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {10,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.61958, 'd12': 1.18795, 'd13': 2.80652},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 330,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.5714, 'd12': 1.19841, 'd13': 2.76953},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 331,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.68593, 'd12': 1.17338, 'd13': 2.85891},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 332,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.50087, 'd12': 1.22722, 'd13': 2.72783},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 333,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.53278, 'd12': 1.21578, 'd13': 2.74802},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 334,
    reactant1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.3333, 'd12': 1.32045, 'd13': 2.65337},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 335,
    reactant1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.60895, 'd12': 1.19765, 'd13': 2.8065},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 336,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4903, 'd12': 1.2363, 'd13': 2.72627},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 337,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.47875, 'd12': 1.27494, 'd13': 2.7441},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 338,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10 *2 H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.37079, 'd12': 1.3353, 'd13': 2.70413},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 339,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12 *2 H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42485, 'd12': 1.31238, 'd13': 2.73645},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 340,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,S} {8,S}
3 *3 O u1 p2 c0  {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10 *2 H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *1 O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9 *2 H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.24878, 'd12': 1.27581, 'd13': 2.52443},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 341,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4014, 'd12': 1.15338, 'd13': 2.55064},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 342,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42331, 'd12': 1.13681, 'd13': 2.55943},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 343,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.34092, 'd12': 1.20843, 'd13': 2.54924},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 344,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,S} {8,S}
3 *3 O u1 p2 c0  {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *1 O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9 *2 H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.30897, 'd12': 1.08962, 'd13': 2.36795},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 345,
    reactant1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 3
1 *3 O u2 p2 c0 
""",
    product1 = """
multiplicity 2
1 *1 O u1 p2 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.21694, 'd12': 1.30766, 'd13': 2.52459},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 346,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.36898, 'd12': 1.35935, 'd13': 2.71107},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 347,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,S} {8,S}
3 *3 O u1 p2 c0  {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *1 O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9 *2 H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.29497, 'd12': 1.25137, 'd13': 2.54477},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 348,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {3,D} {4,S} {5,S}
2    C u0 p0 c0  {3,D} {6,S} {7,S}
3    C u0 p0 c0  {1,D} {2,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {4,S} {5,S}
2    C u0 p0 c0  {1,D} {3,D}
3 *3 C u1 p0 c0  {2,D} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39814, 'd12': 1.29288, 'd13': 2.68982},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 349,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3  *1 C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.50287, 'd12': 1.24358, 'd13': 2.74346},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 350,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.45635, 'd12': 1.27691, 'd13': 2.73245},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 351,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.40453, 'd12': 1.32704, 'd13': 2.71695},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 352,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.46945, 'd12': 1.27233, 'd13': 2.74161},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 353,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.40813, 'd12': 1.32392, 'd13': 2.72161},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 354,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.54225, 'd12': 1.23897, 'd13': 2.78097},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 355,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48069, 'd12': 1.28487, 'd13': 2.7573},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 356,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {10,S}
5     C u0 p0 c0  {3,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.44844, 'd12': 1.30369, 'd13': 2.74594},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 357,
    reactant1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.40254, 'd12': 1.29562, 'd13': 2.69763},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 358,
    reactant1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *1 O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9 *2 H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *3 O u1 p2 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.34532, 'd12': 1.15905, 'd13': 2.50237},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 359,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.36685, 'd12': 1.34346, 'd13': 2.70935},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 360,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.41397, 'd12': 1.32115, 'd13': 2.73455},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 361,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39197, 'd12': 1.32233, 'd13': 2.71424},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 362,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.38667, 'd12': 1.34692, 'd13': 2.73232},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 363,
    reactant1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.41606, 'd12': 1.27405, 'd13': 2.68801},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 364,
    reactant1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *1 O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9 *2 H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *3 O u1 p2 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.34439, 'd12': 1.14532, 'd13': 2.48689},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 365,
    reactant1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.3971, 'd12': 1.35146, 'd13': 2.72129},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 366,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.38379, 'd12': 1.35312, 'd13': 2.70705},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 367,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42342, 'd12': 1.30486, 'd13': 2.7282},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 368,
    reactant1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7 *2 H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4712, 'd12': 1.289, 'd13': 2.75925},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 369,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,S} {8,S}
3 *3 O u1 p2 c0  {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *1 O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9 *2 H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.22322, 'd12': 1.29495, 'd13': 2.51816},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 370,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {4,S}
2    C u0 p0 c0  {1,D} {3,D}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *1 O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *3 O u1 p2 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.28956, 'd12': 1.21428, 'd13': 2.43122},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 371,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.40033, 'd12': 1.32124, 'd13': 2.72027},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 372,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.41519, 'd12': 1.34611, 'd13': 2.75749},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 373,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11 *2 H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    C u0 p0 c0  {1,S} {5,D} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.41789, 'd12': 1.30179, 'd13': 2.71733},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 374,
    reactant1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11 *2 H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.479, 'd12': 1.29585, 'd13': 2.769},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 375,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.40908, 'd12': 1.15072, 'd13': 2.55872},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 376,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.33091, 'd12': 1.22644, 'd13': 2.5551},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 377,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.3856, 'd12': 1.16802, 'd13': 2.55167},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 378,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    C u0 p0 c0  {1,S} {5,D} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.03208, 'd12': 1.25616, 'd13': 2.28495},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 379,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 3
1 *3 O u2 p2 c0 
""",
    product1 = """
multiplicity 2
1 *1 O u1 p2 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    C u0 p0 c0  {1,S} {5,D} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.26764, 'd12': 1.26362, 'd13': 2.52879},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 380,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.37004, 'd12': 1.34244, 'd13': 2.70934},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 381,
    reactant1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.38854, 'd12': 1.36275, 'd13': 2.75065},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 382,
    reactant1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2  *1 C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8  *2 H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.57828, 'd12': 1.22487, 'd13': 2.79964},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 383,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39692, 'd12': 1.32433, 'd13': 2.71827},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 384,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.40724, 'd12': 1.31046, 'd13': 2.71494},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 385,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.40463, 'd12': 1.34608, 'd13': 2.74465},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 386,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48906, 'd12': 1.26802, 'd13': 2.75507},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 387,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.47384, 'd12': 1.30388, 'd13': 2.77606},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 388,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {10,S}
5     C u0 p0 c0  {3,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.44577, 'd12': 1.29455, 'd13': 2.7385},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 389,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {10,S}
5     C u0 p0 c0  {3,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.44111, 'd12': 1.32518, 'd13': 2.76238},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 390,
    reactant1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.56044, 'd12': 1.23357, 'd13': 2.79353},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 391,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    C u0 p0 c0  {1,S} {5,D} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.41813, 'd12': 1.29908, 'd13': 2.71518},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 392,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    C u0 p0 c0  {1,S} {5,D} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.38731, 'd12': 1.32309, 'd13': 2.70918},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 393,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    C u0 p0 c0  {1,S} {5,D} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48978, 'd12': 1.23122, 'd13': 2.71946},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 394,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.37981, 'd12': 1.35666, 'd13': 2.67437},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 395,
    reactant1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.39732, 'd12': 1.36471, 'd13': 2.70692},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 396,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    C u0 p0 c0  {1,S} {5,D} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42207, 'd12': 1.29123, 'd13': 2.71297},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 397,
    reactant1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.48012, 'd12': 1.28849, 'd13': 2.76623},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 398,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,S} {8,S}
3 *3 O u1 p2 c0  {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *1 O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9 *2 H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    C u0 p0 c0  {1,S} {5,D} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.26723, 'd12': 1.26377, 'd13': 2.5295},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 399,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.39807, 'd12': 1.34897, 'd13': 2.7452},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 400,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {4,S}
2    C u0 p0 c0  {1,D} {3,D}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,D}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4    O u0 p2 c0  {1,D}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39662, 'd12': 1.2763, 'd13': 2.65627},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 401,
    reactant1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.38898, 'd12': 1.34982, 'd13': 2.73659},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 402,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,D}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.36152, 'd12': 1.37352, 'd13': 2.66839},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 403,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6  *1 C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21 *2 H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.36122, 'd12': 1.34754, 'd13': 2.70843},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 404,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.47498, 'd12': 1.27439, 'd13': 2.74156},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 405,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39255, 'd12': 1.15711, 'd13': 2.54933},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 406,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {10,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48718, 'd12': 1.2659, 'd13': 2.75167},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 407,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.45259, 'd12': 1.28048, 'd13': 2.73265},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 408,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.52296, 'd12': 1.25105, 'd13': 2.77378},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 409,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.41451, 'd12': 1.30539, 'd13': 2.71983},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 410,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.36752, 'd12': 1.33988, 'd13': 2.70732},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 411,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4082, 'd12': 1.32146, 'd13': 2.72864},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 412,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,S} {8,S}
3 *3 O u1 p2 c0  {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *1 O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9 *2 H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.25339, 'd12': 1.27052, 'd13': 2.52391},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 413,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    C u0 p0 c0  {1,S} {5,D} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.414, 'd12': 1.3002, 'd13': 2.71331},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 414,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 3
1 *3 O u2 p2 c0 
""",
    product1 = """
multiplicity 2
1 *1 O u1 p2 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.23931, 'd12': 1.28855, 'd13': 2.52786},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 415,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42039, 'd12': 1.26732, 'd13': 2.68765},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 416,
    reactant1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {4,S}
2    C u0 p0 c0  {1,D} {3,D}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.52273, 'd12': 1.21954, 'd13': 2.73698},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 417,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 3
1 *3 O u2 p2 c0 
""",
    product1 = """
multiplicity 2
1 *1 O u1 p2 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.30063, 'd12': 1.24711, 'd13': 2.54774},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 418,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.41978, 'd12': 1.27052, 'd13': 2.69014},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 419,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.46706, 'd12': 1.24287, 'd13': 2.70985},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 420,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    reactant2 = """
multiplicity 2
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u1 p2 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 3
1 *3 O u1 p2 c0  {2,S}
2    O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.58035, 'd12': 1.08945, 'd13': 2.66557},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 421,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.39938, 'd12': 1.34062, 'd13': 2.73493},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 422,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12 *2 H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.42796, 'd12': 1.30129, 'd13': 2.72825},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 423,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.32469, 'd12': 1.23285, 'd13': 2.55648},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 424,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.33573, 'd12': 1.22023, 'd13': 2.55506},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 425,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    reactant2 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u0 p2 c0  {1,S} {4,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.31879, 'd12': 1.23278, 'd13': 2.54995},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 426,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {3,D} {4,S} {5,S}
2    C u0 p0 c0  {3,D} {6,S} {7,S}
3    C u0 p0 c0  {1,D} {2,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {4,S} {5,S}
2    C u0 p0 c0  {1,D} {3,D}
3 *3 C u1 p0 c0  {2,D} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.3243, 'd12': 1.38181, 'd13': 2.70604},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 427,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.38315, 'd12': 1.34882, 'd13': 2.7317},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 428,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4515, 'd12': 1.3026, 'd13': 2.75339},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 429,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {10,S}
5     C u0 p0 c0  {3,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42422, 'd12': 1.31705, 'd13': 2.7398},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 430,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.42895, 'd12': 1.30064, 'd13': 2.72899},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 431,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.40298, 'd12': 1.32504, 'd13': 2.7275},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 432,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.53653, 'd12': 1.21498, 'd13': 2.7511},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 433,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.38226, 'd12': 1.35014, 'd13': 2.72797},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 434,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.44255, 'd12': 1.28818, 'd13': 2.73006},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 435,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.38556, 'd12': 1.33952, 'd13': 2.72332},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 436,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.42766, 'd12': 1.30158, 'd13': 2.72917},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 437,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.39717, 'd12': 1.33603, 'd13': 2.73031},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 438,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,D}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.37412, 'd12': 1.37843, 'd13': 2.74968},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 439,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *1 C u0 p0 c0  {1,S} {5,D} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.40849, 'd12': 1.33753, 'd13': 2.7456},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 440,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *1 C u0 p0 c0  {1,S} {5,D} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.34227, 'd12': 1.22081, 'd13': 2.56129},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 441,
    reactant1 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u0 p2 c0  {1,S} {4,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *1 C u0 p0 c0  {1,S} {5,D} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2 *3 O u1 p2 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.32993, 'd12': 1.22373, 'd13': 2.55323},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 442,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {6,S} {7,S}
3 *1 C u0 p0 c0  {1,S} {5,D} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {3,D}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.54891, 'd12': 1.23401, 'd13': 2.77926},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 443,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *1 C u0 p0 c0  {1,S} {5,D} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {10,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.43704, 'd12': 1.32307, 'd13': 2.75649},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 444,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *1 C u0 p0 c0  {1,S} {5,D} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4158, 'd12': 1.3449, 'd13': 2.74243},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 445,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *1 C u0 p0 c0  {1,S} {5,D} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48217, 'd12': 1.30749, 'd13': 2.7756},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 446,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *1 C u0 p0 c0  {1,S} {5,D} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.40241, 'd12': 1.35799, 'd13': 2.74951},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 447,
    reactant1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *1 C u0 p0 c0  {1,S} {5,D} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.38926, 'd12': 1.39311, 'd13': 2.78222},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 448,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {6,S} {7,S}
3 *1 C u0 p0 c0  {1,S} {5,D} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {3,D}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.42115, 'd12': 1.34637, 'd13': 2.76729},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 449,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {6,S} {7,S}
3 *1 C u0 p0 c0  {1,S} {5,D} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {3,D}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.46021, 'd12': 1.29715, 'd13': 2.7571},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 450,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {6,S} {7,S}
3 *1 C u0 p0 c0  {1,S} {5,D} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {3,D}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.40085, 'd12': 1.37034, 'd13': 2.76176},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 451,
    reactant1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *1 C u0 p0 c0  {1,S} {5,D} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.39054, 'd12': 1.38769, 'd13': 2.77622},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 452,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {6,S} {7,S}
3 *1 C u0 p0 c0  {1,S} {5,D} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {3,D}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.44278, 'd12': 1.31025, 'd13': 2.75033},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 453,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {6,S} {7,S}
3 *1 C u0 p0 c0  {1,S} {5,D} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {3,D}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6  *2 H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.44705, 'd12': 1.31835, 'd13': 2.76111},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 454,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {5,S}
2    C u0 p0 c0  {1,S} {4,T}
3 *3 C u1 p0 c0  {1,D} {6,S}
4    C u0 p0 c0  {2,T} {7,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
7    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,D} {3,S} {5,S}
2 *1 C u0 p0 c0  {1,D} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {4,T}
4    C u0 p0 c0  {3,T} {8,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.56893, 'd12': 1.05815, 'd13': 2.62141},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 455,
    reactant1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {5,S}
2    C u0 p0 c0  {1,S} {4,T}
3 *3 C u1 p0 c0  {1,D} {6,S}
4    C u0 p0 c0  {2,T} {7,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
7    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,D} {3,S} {5,S}
2 *1 C u0 p0 c0  {1,D} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {4,T}
4    C u0 p0 c0  {3,T} {8,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7 *2 H u0 p0 c0  {2,S}
8    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    distances = DistanceData(
        distances = {'d23': 1.4952, 'd12': 0.847337, 'd13': 2.34245},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 456,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {5,S}
2    C u0 p0 c0  {1,S} {4,T}
3 *3 C u1 p0 c0  {1,D} {6,S}
4    C u0 p0 c0  {2,T} {7,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
7    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,D} {3,S} {5,S}
2 *1 C u0 p0 c0  {1,D} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {4,T}
4    C u0 p0 c0  {3,T} {8,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7 *2 H u0 p0 c0  {2,S}
8    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.69328, 'd12': 1.17661, 'd13': 2.86926},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 457,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {5,S}
2    C u0 p0 c0  {1,S} {4,T}
3 *3 C u1 p0 c0  {1,D} {6,S}
4    C u0 p0 c0  {2,T} {7,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
7    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,D} {3,S} {5,S}
2 *1 C u0 p0 c0  {1,D} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {4,T}
4    C u0 p0 c0  {3,T} {8,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7 *2 H u0 p0 c0  {2,S}
8    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.5134, 'd12': 1.22941, 'd13': 2.74253},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 458,
    reactant1 = """
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3 *1 C u0 p0 c0  {2,D} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {5,S}
2    C u0 p0 c0  {1,S} {4,T}
3 *3 C u1 p0 c0  {1,D} {6,S}
4    C u0 p0 c0  {2,T} {7,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
7    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,D} {3,S} {5,S}
2 *1 C u0 p0 c0  {1,D} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {4,T}
4    C u0 p0 c0  {3,T} {8,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7 *2 H u0 p0 c0  {2,S}
8    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3 *3 C u1 p0 c0  {2,D} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35025, 'd12': 1.31336, 'd13': 2.66355},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 459,
    reactant1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {5,S}
2    C u0 p0 c0  {1,S} {4,T}
3 *3 C u1 p0 c0  {1,D} {6,S}
4    C u0 p0 c0  {2,T} {7,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
7    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,D} {3,S} {5,S}
2 *1 C u0 p0 c0  {1,D} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {4,T}
4    C u0 p0 c0  {3,T} {8,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7 *2 H u0 p0 c0  {2,S}
8    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35667, 'd12': 1.31451, 'd13': 2.67053},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 460,
    reactant1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {5,S}
2    C u0 p0 c0  {1,S} {4,T}
3 *3 C u1 p0 c0  {1,D} {6,S}
4    C u0 p0 c0  {2,T} {7,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
7    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,D} {3,S} {5,S}
2 *1 C u0 p0 c0  {1,D} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {4,T}
4    C u0 p0 c0  {3,T} {8,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    C u0 p0 c0  {1,D} {4,D}
3    H u0 p0 c0  {1,S}
4    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.37831, 'd12': 1.26578, 'd13': 2.6419},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 461,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *2 H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {5,S}
2    C u0 p0 c0  {1,S} {4,T}
3 *3 C u1 p0 c0  {1,D} {6,S}
4    C u0 p0 c0  {2,T} {7,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
7    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,D} {3,S} {5,S}
2 *1 C u0 p0 c0  {1,D} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {4,T}
4    C u0 p0 c0  {3,T} {8,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7 *2 H u0 p0 c0  {2,S}
8    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39315, 'd12': 1.29177, 'd13': 2.68488},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 462,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,D} {7,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {5,S}
2    C u0 p0 c0  {1,S} {4,T}
3 *3 C u1 p0 c0  {1,D} {6,S}
4    C u0 p0 c0  {2,T} {7,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
7    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,D} {3,S} {5,S}
2 *1 C u0 p0 c0  {1,D} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {4,T}
4    C u0 p0 c0  {3,T} {8,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7 *2 H u0 p0 c0  {2,S}
8    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    C u0 p0 c0  {1,S} {5,D} {6,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.49798, 'd12': 1.23504, 'd13': 2.73061},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 463,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {5,S}
2    C u0 p0 c0  {1,D} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {4,T}
4    C u0 p0 c0  {3,T} {8,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,D} {3,S}
3    C u0 p0 c0  {2,S} {4,T}
4    C u0 p0 c0  {3,T} {7,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 0.96225, 'd12': 1.30416, 'd13': 2.26271},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 464,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {5,S}
2    C u0 p0 c0  {1,D} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {4,T}
4    C u0 p0 c0  {3,T} {8,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {4,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *1 C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,D} {3,S}
3    C u0 p0 c0  {2,S} {4,T}
4    C u0 p0 c0  {3,T} {7,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.43164, 'd12': 1.2622, 'd13': 2.69172},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 465,
    reactant1 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {4,S}
2    C u0 p0 c0  {1,D} {3,D}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {5,S}
2    C u0 p0 c0  {1,D} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {4,T}
4    C u0 p0 c0  {3,T} {8,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {4,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,D}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,D} {3,S}
3    C u0 p0 c0  {2,S} {4,T}
4    C u0 p0 c0  {3,T} {7,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {4,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.37772, 'd12': 1.27591, 'd13': 2.65247},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 466,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11 *2 H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.46922, 'd12': 1.29014, 'd13': 2.74358},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 467,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
4     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
5     C u0 p0 c0  {2,S} {11,S} {12,S} {13,S}
6     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {5,S}
14    H u0 p0 c0  {6,S}
15    H u0 p0 c0  {6,S}
16    H u0 p0 c0  {6,S}
17    H u0 p0 c0  {3,S}
18    H u0 p0 c0  {3,S}
19    H u0 p0 c0  {3,S}
20    H u0 p0 c0  {4,S}
21    H u0 p0 c0  {4,S}
22    H u0 p0 c0  {4,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35535, 'd12': 1.20425, 'd13': 2.55918},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 468,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.16334, 'd12': 1.19113, 'd13': 2.34154},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 469,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u0 p2 c0  {1,S} {4,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.36104, 'd12': 1.18712, 'd13': 2.54519},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 470,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.37029, 'd12': 1.35211, 'd13': 2.7088},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 471,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35672, 'd12': 1.36975, 'd13': 2.72409},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 472,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4149, 'd12': 1.33781, 'd13': 2.75114},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 473,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {10,S}
5     C u0 p0 c0  {3,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39891, 'd12': 1.35061, 'd13': 2.73131},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 474,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.47826, 'd12': 1.26262, 'd13': 2.73345},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 475,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42803, 'd12': 1.30263, 'd13': 2.71906},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 476,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.46208, 'd12': 1.29459, 'd13': 2.75378},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 477,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.57557, 'd12': 1.20557, 'd13': 2.76642},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 478,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.44174, 'd12': 1.30925, 'd13': 2.73402},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 479,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.5025, 'd12': 1.2602, 'd13': 2.75386},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 480,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.45939, 'd12': 1.28569, 'd13': 2.73657},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 481,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.41904, 'd12': 1.31667, 'd13': 2.7347},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 482,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,D}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.33068, 'd12': 1.40976, 'd13': 2.73102},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 483,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.40023, 'd12': 1.33999, 'd13': 2.73812},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 484,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {6,S} {7,S}
3 *1 C u0 p0 c0  {1,S} {5,D} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {3,D}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
4     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
5     C u0 p0 c0  {2,S} {11,S} {12,S} {13,S}
6     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {5,S}
14    H u0 p0 c0  {6,S}
15    H u0 p0 c0  {6,S}
16    H u0 p0 c0  {6,S}
17    H u0 p0 c0  {3,S}
18    H u0 p0 c0  {3,S}
19    H u0 p0 c0  {3,S}
20    H u0 p0 c0  {4,S}
21    H u0 p0 c0  {4,S}
22    H u0 p0 c0  {4,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.34538, 'd12': 1.41187, 'd13': 2.73639},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 485,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {5,S}
2    C u0 p0 c0  {1,S} {4,T}
3 *3 C u1 p0 c0  {1,D} {6,S}
4    C u0 p0 c0  {2,T} {7,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
7    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,D} {3,S} {5,S}
2 *1 C u0 p0 c0  {1,D} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {4,T}
4    C u0 p0 c0  {3,T} {8,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.53028, 'd12': 1.23017, 'd13': 2.74519},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 486,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5  *1 C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17 *2 H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11 *2 H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.36646, 'd12': 1.34198, 'd13': 2.70608},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 487,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
4     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
5  *1 C u0 p0 c0  {2,S} {11,S} {12,S} {13,S}
6     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11 *2 H u0 p0 c0  {5,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {5,S}
14    H u0 p0 c0  {6,S}
15    H u0 p0 c0  {6,S}
16    H u0 p0 c0  {6,S}
17    H u0 p0 c0  {3,S}
18    H u0 p0 c0  {3,S}
19    H u0 p0 c0  {3,S}
20    H u0 p0 c0  {4,S}
21    H u0 p0 c0  {4,S}
22    H u0 p0 c0  {4,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.40229, 'd12': 1.15182, 'd13': 2.55364},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 488,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5  *1 C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17 *2 H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 0.921406, 'd12': 1.3722, 'd13': 2.29351},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 489,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u0 p2 c0  {1,S} {4,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39767, 'd12': 1.14911, 'd13': 2.5466},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 490,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42436, 'd12': 1.29561, 'd13': 2.71976},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 491,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {3,D} {4,S} {5,S}
2    C u0 p0 c0  {3,D} {6,S} {7,S}
3    C u0 p0 c0  {1,D} {2,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {4,S} {5,S}
2    C u0 p0 c0  {1,D} {3,D}
3 *3 C u1 p0 c0  {2,D} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.3869, 'd12': 1.30613, 'd13': 2.69264},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 492,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.45347, 'd12': 1.29464, 'd13': 2.72115},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 493,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.52223, 'd12': 1.25033, 'd13': 2.77109},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 494,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5  *1 C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17 *2 H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.3796, 'd12': 1.32308, 'd13': 2.70218},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 495,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5  *1 C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17 *2 H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8  *2 H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35925, 'd12': 1.35333, 'd13': 2.71199},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 496,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5  *1 C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17 *2 H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.41189, 'd12': 1.27552, 'd13': 2.68619},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 497,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4111, 'd12': 1.3166, 'd13': 2.72353},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 498,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5  *1 C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17 *2 H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.36478, 'd12': 1.34131, 'd13': 2.70397},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 499,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35427, 'd12': 1.35471, 'd13': 2.70828},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 500,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.40477, 'd12': 1.32664, 'd13': 2.72937},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 501,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,D}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.4558, 'd12': 1.29628, 'd13': 2.75088},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 502,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48981, 'd12': 1.27166, 'd13': 2.75918},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 503,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {5,S} {13,D}
5     O u0 p2 c0  {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {4,D}
14 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {5,S} {14,D}
5     O u0 p2 c0  {4,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {15,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    O u0 p2 c0  {4,D}
15 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.29083, 'd12': 1.27513, 'd13': 2.56346},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 504,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {5,S} {13,D}
5     O u0 p2 c0  {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {4,D}
14 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {5,S} {14,D}
5     O u0 p2 c0  {4,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {15,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    O u0 p2 c0  {4,D}
15 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.26436, 'd12': 1.29226, 'd13': 2.55636},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 505,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {5,S} {13,D}
5     O u0 p2 c0  {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {4,D}
14 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {5,S} {14,D}
5     O u0 p2 c0  {4,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {15,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    O u0 p2 c0  {4,D}
15 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.29297, 'd12': 1.1007, 'd13': 2.36587},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 506,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {5,S} {13,D}
5     O u0 p2 c0  {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {4,D}
14 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {5,S} {14,D}
5     O u0 p2 c0  {4,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {15,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    O u0 p2 c0  {4,D}
15 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.28509, 'd12': 1.11254, 'd13': 2.35466},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 507,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {5,S} {13,D}
5     O u0 p2 c0  {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {4,D}
14 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {5,S} {14,D}
5     O u0 p2 c0  {4,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {15,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    O u0 p2 c0  {4,D}
15 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {10,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.38764, 'd12': 1.22107, 'd13': 2.60764},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 508,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {5,S} {13,D}
5     O u0 p2 c0  {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {4,D}
14 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {5,S} {14,D}
5     O u0 p2 c0  {4,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {15,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    O u0 p2 c0  {4,D}
15 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.34824, 'd12': 1.23778, 'd13': 2.58597},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 509,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {5,S} {13,D}
5     O u0 p2 c0  {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {4,D}
14 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {5,S} {14,D}
5     O u0 p2 c0  {4,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {15,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    O u0 p2 c0  {4,D}
15 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.31637, 'd12': 1.25494, 'd13': 2.57087},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 510,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {5,S} {13,D}
5     O u0 p2 c0  {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {4,D}
14 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {5,S} {14,D}
5     O u0 p2 c0  {4,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {15,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    O u0 p2 c0  {4,D}
15 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.33531, 'd12': 1.2485, 'd13': 2.57495},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 511,
    reactant1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {5,S} {13,D}
5     O u0 p2 c0  {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {4,D}
14 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {5,S} {14,D}
5     O u0 p2 c0  {4,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {15,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    O u0 p2 c0  {4,D}
15 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.35139, 'd12': 1.23786, 'd13': 2.58357},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 512,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {5,S} {14,D}
5     O u0 p2 c0  {4,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {15,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    O u0 p2 c0  {4,D}
15 *2 H u0 p0 c0  {6,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {5,S} {13,D}
5     O u0 p2 c0  {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {4,D}
14 *3 O u1 p2 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.32962, 'd12': 1.2071, 'd13': 2.53574},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 513,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {5,S} {14,D}
5     O u0 p2 c0  {4,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {15,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    O u0 p2 c0  {4,D}
15 *2 H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {5,S} {13,D}
5     O u0 p2 c0  {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {4,D}
14 *3 O u1 p2 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.41998, 'd12': 1.11146, 'd13': 2.53061},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 514,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11 *2 H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.47185, 'd12': 1.27947, 'd13': 2.73907},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 515,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u0 p2 c0  {1,S} {4,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.34221, 'd12': 1.20364, 'd13': 2.54311},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 516,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35988, 'd12': 1.37476, 'd13': 2.72511},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 517,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.43263, 'd12': 1.32677, 'd13': 2.75306},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 518,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.50195, 'd12': 1.25494, 'd13': 2.75148},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 519,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8  *2 H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48331, 'd12': 1.2758, 'd13': 2.74918},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 520,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.45507, 'd12': 1.29902, 'd13': 2.7437},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 521,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.55469, 'd12': 1.20924, 'd13': 2.76225},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 522,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.43153, 'd12': 1.31295, 'd13': 2.72826},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 523,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48449, 'd12': 1.26998, 'd13': 2.74554},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 524,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,S} {8,S}
3 *3 O u1 p2 c0  {2,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *1 O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9 *2 H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.29472, 'd12': 1.26032, 'd13': 2.55282},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 525,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4146, 'd12': 1.31069, 'd13': 2.71524},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 526,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.46939, 'd12': 1.27873, 'd13': 2.73755},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 527,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,T} {3,S}
2 *3 C u1 p0 c0  {1,T}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
1    C u0 p0 c0  {2,T} {3,S}
2 *1 C u0 p0 c0  {1,T} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.77539, 'd12': 1.13473, 'd13': 2.8567},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 528,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,D}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.33572, 'd12': 1.41477, 'd13': 2.74611},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 529,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39812, 'd12': 1.34214, 'd13': 2.73691},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 530,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {6,S} {7,S}
3 *1 C u0 p0 c0  {1,S} {5,D} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {3,D}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8 *2 H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.32478, 'd12': 1.42925, 'd13': 2.74904},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 531,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {5,S} {13,D}
5     O u0 p2 c0  {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {4,D}
14 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {5,S} {14,D}
5     O u0 p2 c0  {4,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {15,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    O u0 p2 c0  {4,D}
15 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.29147, 'd12': 1.27437, 'd13': 2.56139},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 532,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.3485, 'd12': 1.39534, 'd13': 2.73601},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 533,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11 *2 H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.43033, 'd12': 1.30554, 'd13': 2.73549},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 534,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.32983, 'd12': 1.22888, 'd13': 2.55778},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 535,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.08399, 'd12': 1.2379, 'd13': 2.32103},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 536,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    reactant2 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u0 p2 c0  {1,S} {4,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2  *1 C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10 *2 H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    product2 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.30689, 'd12': 1.24721, 'd13': 2.55389},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 537,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.35236, 'd12': 1.3836, 'd13': 2.73459},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 538,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2  *1 C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10 *2 H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.38536, 'd12': 1.34647, 'd13': 2.73158},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 539,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2  *1 C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10 *2 H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.45021, 'd12': 1.30834, 'd13': 2.75849},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 540,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2  *1 C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10 *2 H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {10,S}
5     C u0 p0 c0  {3,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42413, 'd12': 1.32471, 'd13': 2.74816},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 541,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.46516, 'd12': 1.27571, 'd13': 2.74009},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 542,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.43311, 'd12': 1.30286, 'd13': 2.73532},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 543,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.40728, 'd12': 1.32641, 'd13': 2.73254},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 544,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.38674, 'd12': 1.35192, 'd13': 2.73439},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 545,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,D}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,D} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    O u0 p2 c0  {2,D}
7 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.3836, 'd12': 1.38216, 'd13': 2.76484},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 546,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,D} {6,S}
3    O u0 p2 c0  {2,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {2,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.38984, 'd12': 1.33976, 'd13': 2.72832},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 547,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5 *2 H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.43083, 'd12': 1.30418, 'd13': 2.73393},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 548,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.4021, 'd12': 1.33664, 'd13': 2.7349},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 549,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,D} {3,S}
2    O u0 p2 c0  {1,D}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,D}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    O u0 p2 c0  {1,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.385, 'd12': 1.37374, 'd13': 2.7572},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 550,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.37265, 'd12': 1.36752, 'd13': 2.73991},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 551,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *1 C u0 p0 c0  {1,S} {5,D} {6,S}
3    C u0 p0 c0  {1,D} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    O u0 p2 c0  {2,D}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.37093, 'd12': 1.37954, 'd13': 2.74137},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 552,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.34254, 'd12': 1.39866, 'd13': 2.7296},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 553,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {3,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {4,D}
4     C u0 p0 c0  {3,D} {11,D}
5  *2 H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    O u0 p2 c0  {4,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {5,S} {6,S} {7,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3  *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4     C u0 p0 c0  {2,D} {10,D}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {3,S}
9     H u0 p0 c0  {3,S}
10    O u0 p2 c0  {4,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.34438, 'd12': 1.40445, 'd13': 2.74589},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 554,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {6,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {9,D}
4     C u0 p0 c0  {2,D} {10,S} {11,S}
5     O u0 p2 c0  {3,S} {12,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     O u0 p2 c0  {3,D}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
12 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {7,S} {8,S} {9,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {10,D}
4     C u0 p0 c0  {2,D} {11,S} {12,S}
5     O u0 p2 c0  {3,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {1,S}
10    O u0 p2 c0  {3,D}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
13 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.28163, 'd12': 1.28076, 'd13': 2.5505},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 555,
    reactant1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {6,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {9,D}
4     C u0 p0 c0  {2,D} {10,S} {11,S}
5     O u0 p2 c0  {3,S} {12,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     O u0 p2 c0  {3,D}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
12 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {7,S} {8,S} {9,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {10,D}
4     C u0 p0 c0  {2,D} {11,S} {12,S}
5     O u0 p2 c0  {3,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {1,S}
10    O u0 p2 c0  {3,D}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
13 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.31178, 'd12': 1.09719, 'd13': 2.37274},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 556,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {6,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {9,D}
4     C u0 p0 c0  {2,D} {10,S} {11,S}
5     O u0 p2 c0  {3,S} {12,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     O u0 p2 c0  {3,D}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
12 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {7,S} {8,S} {9,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {10,D}
4     C u0 p0 c0  {2,D} {11,S} {12,S}
5     O u0 p2 c0  {3,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {1,S}
10    O u0 p2 c0  {3,D}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
13 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.28376, 'd12': 1.28153, 'd13': 2.55387},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 557,
    reactant1 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    reactant2 = """
1     C u0 p0 c0  {2,S} {7,S} {8,S} {9,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {10,D}
4     C u0 p0 c0  {2,D} {11,S} {12,S}
5     O u0 p2 c0  {3,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {1,S}
10    O u0 p2 c0  {3,D}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
13 *2 H u0 p0 c0  {6,S}
""",
    product1 = """
1 *2 H u0 p0 c0  {2,S}
2 *1 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {6,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {9,D}
4     C u0 p0 c0  {2,D} {10,S} {11,S}
5     O u0 p2 c0  {3,S} {12,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     O u0 p2 c0  {3,D}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
12 *3 O u1 p2 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.0033, 'd12': 1.12951, 'd13': 2.13189},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 558,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9  *2 H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {6,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {9,D}
4     C u0 p0 c0  {2,D} {10,S} {11,S}
5     O u0 p2 c0  {3,S} {12,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     O u0 p2 c0  {3,D}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
12 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {7,S} {8,S} {9,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {10,D}
4     C u0 p0 c0  {2,D} {11,S} {12,S}
5     O u0 p2 c0  {3,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {1,S}
10    O u0 p2 c0  {3,D}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
13 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {5,S} {9,S}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {10,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {5,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.40386, 'd12': 1.21533, 'd13': 2.61884},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 559,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {6,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {9,D}
4     C u0 p0 c0  {2,D} {10,S} {11,S}
5     O u0 p2 c0  {3,S} {12,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     O u0 p2 c0  {3,D}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
12 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {7,S} {8,S} {9,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {10,D}
4     C u0 p0 c0  {2,D} {11,S} {12,S}
5     O u0 p2 c0  {3,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {1,S}
10    O u0 p2 c0  {3,D}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
13 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.34264, 'd12': 1.2428, 'd13': 2.5851},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 560,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {6,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {9,D}
4     C u0 p0 c0  {2,D} {10,S} {11,S}
5     O u0 p2 c0  {3,S} {12,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     O u0 p2 c0  {3,D}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
12 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {7,S} {8,S} {9,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {10,D}
4     C u0 p0 c0  {2,D} {11,S} {12,S}
5     O u0 p2 c0  {3,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {1,S}
10    O u0 p2 c0  {3,D}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
13 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.43921, 'd12': 1.20346, 'd13': 2.64238},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 561,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {6,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {9,D}
4     C u0 p0 c0  {2,D} {10,S} {11,S}
5     O u0 p2 c0  {3,S} {12,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     O u0 p2 c0  {3,D}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
12 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {7,S} {8,S} {9,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {10,D}
4     C u0 p0 c0  {2,D} {11,S} {12,S}
5     O u0 p2 c0  {3,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {1,S}
10    O u0 p2 c0  {3,D}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
13 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.26042, 'd12': 1.28937, 'd13': 2.5497},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 562,
    reactant1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {6,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {9,D}
4     C u0 p0 c0  {2,D} {10,S} {11,S}
5     O u0 p2 c0  {3,S} {12,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     O u0 p2 c0  {3,D}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
12 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {7,S} {8,S} {9,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {10,D}
4     C u0 p0 c0  {2,D} {11,S} {12,S}
5     O u0 p2 c0  {3,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {1,S}
10    O u0 p2 c0  {3,D}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
13 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.32826, 'd12': 1.25352, 'd13': 2.57242},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 563,
    reactant1 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {6,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {9,D}
4     C u0 p0 c0  {2,D} {10,S} {11,S}
5     O u0 p2 c0  {3,S} {12,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     O u0 p2 c0  {3,D}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
12 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {7,S} {8,S} {9,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {10,D}
4     C u0 p0 c0  {2,D} {11,S} {12,S}
5     O u0 p2 c0  {3,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {1,S}
10    O u0 p2 c0  {3,D}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
13 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.238, 'd12': 1.30885, 'd13': 2.54504},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 564,
    reactant1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {7,S}
2     C u0 p0 c0  {1,S} {8,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {5,S} {14,D}
5     O u0 p2 c0  {4,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {15,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    O u0 p2 c0  {4,D}
15 *2 H u0 p0 c0  {6,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {6,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {9,D}
4     C u0 p0 c0  {2,D} {10,S} {11,S}
5     O u0 p2 c0  {3,S} {12,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     O u0 p2 c0  {3,D}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {4,S}
12 *3 O u1 p2 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {7,S} {8,S} {9,S}
2     C u0 p0 c0  {1,S} {3,S} {4,D}
3     C u0 p0 c0  {2,S} {5,S} {10,D}
4     C u0 p0 c0  {2,D} {11,S} {12,S}
5     O u0 p2 c0  {3,S} {6,S}
6  *1 O u0 p2 c0  {5,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {1,S}
10    O u0 p2 c0  {3,D}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {4,S}
13 *2 H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {6,S}
2     C u0 p0 c0  {1,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {5,S} {13,D}
5     O u0 p2 c0  {4,S} {14,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    O u0 p2 c0  {4,D}
14 *3 O u1 p2 c0  {5,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.18494, 'd12': 1.17814, 'd13': 2.36175},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 565,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8  *2 H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
3     C u0 p0 c0  {1,S} {12,S} {13,S} {14,S}
4     C u0 p0 c0  {6,S} {15,S} {16,S} {17,S}
5     C u0 p0 c0  {6,S} {18,S} {19,S} {20,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {21,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    O u0 p2 c0  {7,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.47701, 'd12': 1.27934, 'd13': 2.74805},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 566,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20 *2 H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11 *2 H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35259, 'd12': 1.35903, 'd13': 2.71095},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 567,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {10,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4  *1 C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14 *2 H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42318, 'd12': 1.15057, 'd13': 2.54778},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 568,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {10,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4  *1 C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14 *2 H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.41715, 'd12': 1.14131, 'd13': 2.55597},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 569,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20 *2 H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1 *3 H u1 p0 c0 
""",
    product1 = """
1 *1 H u0 p0 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 0.910509, 'd12': 1.3793, 'd13': 2.28925},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 570,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3 *3 C u1 p0 c0  {1,S} {7,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {3,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.4607, 'd12': 1.27318, 'd13': 2.73105},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 571,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {3,S} {5,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {2,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {1,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {6,D}
3     C u0 p0 c0  {1,S} {5,D} {9,S}
4  *3 C u1 p0 c0  {2,S} {5,S} {10,S}
5     C u0 p0 c0  {3,D} {4,S} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.51782, 'd12': 1.2605, 'd13': 2.77411},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 572,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20 *2 H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {3,S} {4,S}
2 *3 C u1 p0 c0  {1,D} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    C u0 p0 c0  {1,D} {5,S} {6,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39691, 'd12': 1.29783, 'd13': 2.69417},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 573,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20 *2 H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.37792, 'd12': 1.32647, 'd13': 2.70384},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 574,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20 *2 H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3  *3 C u1 p0 c0  {1,S} {9,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2  *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7  *2 H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.34141, 'd12': 1.37365, 'd13': 2.71447},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 575,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2     C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3     C u0 p0 c0  {1,S} {9,S} {10,S} {11,S}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {2,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3  *3 C u1 p0 c0  {1,S} {2,S} {10,S}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39253, 'd12': 1.32584, 'd13': 2.71732},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 576,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20 *2 H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 3
1 *3 C u2 p0 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
multiplicity 2
1 *1 C u1 p0 c0  {2,S} {3,S} {4,S}
2    H u0 p0 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.38888, 'd12': 1.29189, 'd13': 2.68057},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 577,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2 *3 C u1 p0 c0  {1,S} {3,S} {7,S}
3    O u0 p2 c0  {2,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42442, 'd12': 1.30392, 'd13': 2.72808},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 578,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20 *2 H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    O u0 p2 c0  {1,S} {8,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {3,S}
""",
    product1 = """
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *1 C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3    O u0 p2 c0  {1,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7 *2 H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
9    H u0 p0 c0  {3,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35499, 'd12': 1.35632, 'd13': 2.71012},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 579,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {6,S} {7,S} {8,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2 *3 C u1 p0 c0  {1,S} {6,S} {7,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35529, 'd12': 1.35404, 'd13': 2.70845},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 580,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {3,S} {4,S} {5,S}
2    O u0 p2 c0  {1,S} {6,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,S} {4,S}
2    O u0 p2 c0  {1,S} {5,S}
3    H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.41284, 'd12': 1.31902, 'd13': 2.72837},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 581,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20 *2 H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,T} {3,S}
2 *3 C u1 p0 c0  {1,T}
3    H u0 p0 c0  {1,S}
""",
    product1 = """
1    C u0 p0 c0  {2,T} {3,S}
2 *1 C u0 p0 c0  {1,T} {4,S}
3    H u0 p0 c0  {1,S}
4 *2 H u0 p0 c0  {2,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.80797, 'd12': 1.12563, 'd13': 2.93169},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 582,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,D} {3,S} {4,S}
2    O u0 p2 c0  {1,D}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {1,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {3,D}
2    H u0 p0 c0  {1,S}
3    O u0 p2 c0  {1,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.46532, 'd12': 1.28402, 'd13': 2.74078},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 583,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,D} {7,S}
3    C u0 p0 c0  {2,D} {8,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {2,S}
8    O u0 p2 c0  {3,D}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {4,S}
2 *3 C u1 p0 c0  {1,S} {5,S} {6,S}
3    C u0 p0 c0  {1,D} {7,D}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {2,S}
6    H u0 p0 c0  {2,S}
7    O u0 p2 c0  {3,D}
""",
    distances = DistanceData(
        distances = {'d23': 1.44306, 'd12': 1.29554, 'd13': 2.73801},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 584,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20 *2 H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {3,D} {5,S}
2    C u0 p0 c0  {1,S} {4,T}
3 *3 C u1 p0 c0  {1,D} {6,S}
4    C u0 p0 c0  {2,T} {7,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
7    H u0 p0 c0  {4,S}
""",
    product1 = """
1    C u0 p0 c0  {2,D} {3,S} {5,S}
2 *1 C u0 p0 c0  {1,D} {6,S} {7,S}
3    C u0 p0 c0  {1,S} {4,T}
4    C u0 p0 c0  {3,T} {8,S}
5    H u0 p0 c0  {1,S}
6 *2 H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
8    H u0 p0 c0  {4,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.42229, 'd12': 1.27441, 'd13': 2.69495},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 585,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2  *1 C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10 *2 H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.47934, 'd12': 1.28634, 'd13': 2.75686},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 586,
    reactant1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20 *2 H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21 *2 H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35438, 'd12': 1.36092, 'd13': 2.71277},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 587,
    reactant1 = """
multiplicity 2
1     C u0 p0 c0  {4,S} {5,S} {6,S} {10,S}
2     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
3     C u0 p0 c0  {2,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {1,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {2,S} {20,D}
7  *3 C u1 p0 c0  {2,S} {21,S} {22,S}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    O u0 p2 c0  {6,D}
21    H u0 p0 c0  {7,S}
22    H u0 p0 c0  {7,S}
23    H u0 p0 c0  {9,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2  *1 C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11 *2 H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {11,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6  *1 C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9     O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {1,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22 *2 H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24    H u0 p0 c0  {9,S}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {2,S} {3,S} {7,S} {10,S}
2     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
3     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
4     C u0 p0 c0  {6,S} {16,S} {17,S} {18,S}
5     C u0 p0 c0  {6,S} {19,S} {20,S} {21,S}
6  *3 C u1 p0 c0  {4,S} {5,S} {7,S}
7     C u0 p0 c0  {1,S} {6,S} {22,D}
8     O u0 p2 c0  {2,S} {9,S}
9     O u0 p2 c0  {8,S} {23,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {2,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {3,S}
15    H u0 p0 c0  {3,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {4,S}
18    H u0 p0 c0  {4,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {5,S}
21    H u0 p0 c0  {5,S}
22    O u0 p2 c0  {7,D}
23    H u0 p0 c0  {9,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.47355, 'd12': 1.27934, 'd13': 2.74281},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 588,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,D}
3 *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
multiplicity 2
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u1 p2 c0  {1,S}
3 *2 H u0 p0 c0  {1,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,D}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 3
1 *3 O u1 p2 c0  {2,S}
2    O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.6743, 'd12': 1.05367, 'd13': 2.72623},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 589,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,D}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {6,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {2,S} {19,D}
7  *3 C u1 p0 c0  {2,S} {20,S} {21,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    O u0 p2 c0  {6,D}
20    H u0 p0 c0  {7,S}
21    H u0 p0 c0  {7,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3  *1 C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12 *2 H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,D}
3 *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39801, 'd12': 1.31595, 'd13': 2.71349},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 590,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,D}
3 *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {11,S} {12,S} {13,S}
4     C u0 p0 c0  {1,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {2,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {1,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,D}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {5,S} {6,S} {7,S} {9,S}
3     C u0 p0 c0  {1,S} {10,S} {11,S} {12,S}
4     C u0 p0 c0  {1,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {2,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {1,S} {23,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {3,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.39545, 'd12': 1.15796, 'd13': 2.55229},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 591,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,D}
3 *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1     C u0 p0 c0  {3,S} {6,S} {7,S} {10,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {11,S}
3     C u0 p0 c0  {1,S} {8,S} {12,S} {13,S}
4     C u0 p0 c0  {2,S} {14,S} {15,S} {16,S}
5     C u0 p0 c0  {2,S} {17,S} {18,S} {19,S}
6     C u0 p0 c0  {1,S} {20,S} {21,S} {22,S}
7     C u0 p0 c0  {1,S} {2,S} {23,D}
8     O u0 p2 c0  {3,S} {9,S}
9  *1 O u0 p2 c0  {8,S} {24,S}
10    H u0 p0 c0  {1,S}
11    H u0 p0 c0  {2,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {3,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {4,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {5,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    H u0 p0 c0  {6,S}
23    O u0 p2 c0  {7,D}
24 *2 H u0 p0 c0  {9,S}
""",
    product1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,D}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {6,S} {7,S} {9,S}
2     C u0 p0 c0  {4,S} {5,S} {7,S} {10,S}
3     C u0 p0 c0  {1,S} {8,S} {11,S} {12,S}
4     C u0 p0 c0  {2,S} {13,S} {14,S} {15,S}
5     C u0 p0 c0  {2,S} {16,S} {17,S} {18,S}
6     C u0 p0 c0  {1,S} {19,S} {20,S} {21,S}
7     C u0 p0 c0  {1,S} {2,S} {22,D}
8     O u0 p2 c0  {3,S} {23,S}
9     H u0 p0 c0  {1,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {3,S}
12    H u0 p0 c0  {3,S}
13    H u0 p0 c0  {4,S}
14    H u0 p0 c0  {4,S}
15    H u0 p0 c0  {4,S}
16    H u0 p0 c0  {5,S}
17    H u0 p0 c0  {5,S}
18    H u0 p0 c0  {5,S}
19    H u0 p0 c0  {6,S}
20    H u0 p0 c0  {6,S}
21    H u0 p0 c0  {6,S}
22    O u0 p2 c0  {7,D}
23 *3 O u1 p2 c0  {8,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.41087, 'd12': 1.14781, 'd13': 2.55822},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 592,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,D}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
""",
    reactant2 = """
multiplicity 3
1 *3 O u2 p2 c0 
""",
    product1 = """
multiplicity 2
1 *1 O u1 p2 c0  {2,S}
2 *2 H u0 p0 c0  {1,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,D}
3 *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.26019, 'd12': 1.26963, 'd13': 2.52793},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 593,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,D}
3 *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1 *1 O u0 p2 c0  {2,S} {3,S}
2    O u0 p2 c0  {1,S} {4,S}
3 *2 H u0 p0 c0  {1,S}
4    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2  *1 C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,D}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1    O u0 p2 c0  {2,S} {3,S}
2    H u0 p0 c0  {1,S}
3 *3 O u1 p2 c0  {1,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.37445, 'd12': 1.16774, 'd13': 2.54032},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 594,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,D}
3 *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {7,S}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    H u0 p0 c0  {3,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2  *1 C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,D}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1 *3 C u1 p0 c0  {2,S} {4,S} {5,S}
2    C u0 p0 c0  {1,S} {3,T}
3    C u0 p0 c0  {2,T} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.3788, 'd12': 1.33357, 'd13': 2.71049},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 595,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,D}
3 *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1 *1 C u0 p0 c0  {3,D} {4,S} {5,S}
2    C u0 p0 c0  {3,D} {6,S} {7,S}
3    C u0 p0 c0  {1,D} {2,D}
4 *2 H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {2,S}
7    H u0 p0 c0  {2,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2  *1 C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,D}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,D} {4,S} {5,S}
2    C u0 p0 c0  {1,D} {3,D}
3 *3 C u1 p0 c0  {2,D} {6,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.35261, 'd12': 1.33585, 'd13': 2.6873},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 596,
    reactant1 = """
1  *1 C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2     C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,D}
4  *2 H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
""",
    reactant2 = """
multiplicity 2
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3     C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6  *3 C u1 p0 c0  {4,B} {5,B}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
""",
    product1 = """
1     C u0 p0 c0  {2,B} {3,B} {7,S}
2     C u0 p0 c0  {1,B} {4,B} {8,S}
3  *1 C u0 p0 c0  {1,B} {5,B} {9,S}
4     C u0 p0 c0  {2,B} {6,B} {10,S}
5     C u0 p0 c0  {3,B} {6,B} {11,S}
6     C u0 p0 c0  {4,B} {5,B} {12,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
""",
    product2 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,D}
3 *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.48044, 'd12': 1.24559, 'd13': 2.72562},
        method = "B3LYP/6-31+G(d,p)",
    ),
    reference = None,
    referenceType = "",
    rank = 3,
    shortDesc = u"""B3LYP/6-31+G(d,p) calculation via group additive TS generator.""",
    longDesc = 
u"""
""",
)

entry(
    index = 597,
    reactant1 = """
multiplicity 2
1    C u0 p0 c0  {2,S} {4,S} {5,S} {6,S}
2    C u0 p0 c0  {1,S} {3,S} {7,D}
3 *3 C u1 p0 c0  {2,S} {8,S} {9,S}
4    H u0 p0 c0  {1,S}
5    H u0 p0 c0  {1,S}
6    H u0 p0 c0  {1,S}
7    O u0 p2 c0  {2,D}
8    H u0 p0 c0  {3,S}
9    H u0 p0 c0  {3,S}
""",
    reactant2 = """
1  *1 C u0 p0 c0  {2,S} {3,S} {7,S} {8,S}
2     C u0 p0 c0  {1,S} {4,S} {9,S} {10,S}
3     C u0 p0 c0  {1,S} {5,S} {6,D}
4     C u0 p0 c0  {2,S} {5,D} {11,S}
5     C u0 p0 c0  {3,S} {4,D} {12,S}
6     C u0 p0 c0  {3,D} {13,S} {14,S}
7  *2 H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {2,S}
10    H u0 p0 c0  {2,S}
11    H u0 p0 c0  {4,S}
12    H u0 p0 c0  {5,S}
13    H u0 p0 c0  {6,S}
14    H u0 p0 c0  {6,S}
""",
    product1 = """
1     C u0 p0 c0  {3,S} {4,S} {5,S} {6,S}
2  *1 C u0 p0 c0  {3,S} {7,S} {8,S} {9,S}
3     C u0 p0 c0  {1,S} {2,S} {10,D}
4     H u0 p0 c0  {1,S}
5     H u0 p0 c0  {1,S}
6     H u0 p0 c0  {1,S}
7     H u0 p0 c0  {2,S}
8     H u0 p0 c0  {2,S}
9  *2 H u0 p0 c0  {2,S}
10    O u0 p2 c0  {3,D}
""",
    product2 = """
multiplicity 2
1     C u0 p0 c0  {3,S} {4,S} {7,S} {8,S}
2     C u0 p0 c0  {3,S} {5,S} {6,D}
3  *3 C u1 p0 c0  {1,S} {2,S} {9,S}
4     C u0 p0 c0  {1,S} {5,D} {10,S}
5     C u0 p0 c0  {2,S} {4,D} {11,S}
6     C u0 p0 c0  {2,D} {12,S} {13,S}
7     H u0 p0 c0  {1,S}
8     H u0 p0 c0  {1,S}
9     H u0 p0 c0  {3,S}
10    H u0 p0 c0  {4,S}
11    H u0 p0 c0  {5,S}
12    H u0 p0 c0  {6,S}
13    H u0 p0 c0  {6,S}
""",
    distances = DistanceData(
        distances = {'d23': 1.41607, 'd1